<!DOCTYPE html>

<html>
	
	<head>
	
		<meta charset="UTF-8">
	
		<base href="<?php echo e(url('/')); ?>">
	
		<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	
		<meta name="api-base-url" content="<?php echo e(url('/')); ?>" />
	
		<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

		<link href="<?php echo e(assetLink('css','widgetbox')); ?>" rel="stylesheet" type="text/css" />
	
		<link href="<?php echo e(assetLink('css','bootstrap-4')); ?>" rel="stylesheet" type="text/css" />
	
		<link href="<?php echo e(assetLink('css','font-awesome-5')); ?>" rel="stylesheet" type="text/css" />
	
		<link href="<?php echo e(assetLink('css','intlTelInput')); ?>" rel="stylesheet" type="text/css" />
	
		<link href="<?php echo e(assetLink('css','client-custom-css')); ?>" rel="stylesheet" type="text/css" />
	
		<link href="<?php echo e(assetLink('css','jquery-rating')); ?>" rel="stylesheet" type="text/css" />
	
		<script src="<?php echo e(assetLink('js','jquery-3')); ?>" type="text/javascript" media="none" onload="this.media='all';">
			
		</script>

		<!-- for recaptcha session storage we are using this file-->
		<?php echo $__env->make('themes.default1.common.recaptcha', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
			
		</script>
		
		<script src="<?php echo e(assetLink('js','polyfill')); ?>"></script>
		
		<link href="<?php echo e(assetLink('css','select2')); ?>" rel="stylesheet" type="text/css" />

		<link href="<?php echo e(assetLink('css','ckeditor-css')); ?>" rel="stylesheet" type="text/css" />

	  <!-- check if lanuage is RTL, if yes, inject bootstrap-RTL -->
	  
	  <?php
		  $lang = App::getLocale();
		  if($lang == 'ar'){
			$bootstrapRTLPath = assetLink('css','bootstrap-rtl');
			echo "<link href=$bootstrapRTLPath rel='stylesheet' type='text/css'/>";
		  }
		?>

		<?php
		  try {
				$seo =  new \App\Http\Controllers\Client\helpdesk\SeoController();
				$layoutController = new \App\Http\Controllers\Client\helpdesk\ClientLayoutController();
				$authController = new App\Http\Controllers\Auth\AuthController();
				// layout data
				$layout = $layoutController->getLayoutData();
				// auth user data
				$authInfo = $authController->getLoggedInClientInfo();
				// dd($layout, $authInfo);
				$response = $seo->getUrlandAppendTitleDescription();
				$meta = json_decode($response->content())->data;
			} catch(\Exception $e) {
				// ignore exception
			}
		?>

		<meta name="title" content="<?php echo $meta->title; ?> :: <?php echo strip_tags($meta->company_name); ?>">
		
		<meta name="description" content="<?php echo $meta->description; ?>">
		
		<meta content="<?php echo $meta->company_logo; ?>" property="og:image">
		<?php \Event::dispatch('customcss-event', [['fired_at' => 'clientlayout','request' => Request()]]); ?>
	</head>
	
	<body>

		<script type="text/javascript">
			sessionStorage.setItem('data_time_format', '<?php echo e(dateTimeFormat()); ?>');
            sessionStorage.setItem('date_format', '<?php echo e(dateFormat()); ?>');
            sessionStorage.setItem('timezone', '<?php echo e(agentTimeZone()); ?>');
		</script>
		<?php echo $__env->make('themes.default1.common.socket', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		
		<div id="app-client-panel">

			<client-panel-renderer :layout-details="<?php echo e(json_encode($layout)); ?>" 
				:auth-info="<?php echo e(json_encode($authInfo)); ?>">
					
			</client-panel-renderer>
		</div>

		<script type="text/javascript" src="<?php echo e(bundleLink('js/lang' )); ?>"></script>

		<script type="text/javascript" src="<?php echo e(bundleLink('js/common.js')); ?>"></script>

		<script type="text/javascript" src="<?php echo e(bundleLink('js/app.js')); ?>"></script>

		<script src="<?php echo e(assetLink('js','select2')); ?>"></script>

		<script type="text/javascript" src="<?php echo e(assetLink('js','popper')); ?>"></script>

		<script type="text/javascript" src="<?php echo e(assetLink('js','bootstrap-4')); ?>"></script>

		<script type="text/javascript" src="<?php echo e(assetLink('js','superfish')); ?>"></script>

		<script type="text/javascript" src="<?php echo e(assetLink('js','mobilemenu')); ?>"></script>
		
		<script type="text/javascript">
			localStorage.setItem('LANGUAGE', '<?php echo e(Lang::getLocale()); ?>');
		</script>
		<?php \Event::dispatch('timeline-customjs', [['fired_at' => 'clientlayout','request' => Request()]]); ?>

		<?php
			// adding scripts for plugins
			// there's no point in adding the entire script, so we can use dynamic import
			// emit an event which ldap is listening to
			\Event::dispatch('client-panel-scripts-dispatch');
		?>


	</body>
</html><?php /**PATH /home/localida/marcoquan.com/sistemadeatencionv2/resources/views/themes/default1/client/layout/spa.blade.php ENDPATH**/ ?>