<!DOCTYPE html>
<html  ng-app="fbApp">
 <?php
    $company = App\Model\helpdesk\Settings\Company::where('id', '=', '1')->first();
    $portal = App\Model\helpdesk\Theme\Portal::where('id', '=', 1)->first();
    $title = App\Model\helpdesk\Settings\System::where('id', '=', '1')->value('name');
    $title_name = isset($title) ? $title : "SUPPORT CENTER";
    $navbar_class = $portal->admin_header_color ? str_replace("skin","navbar-dark navbar", $portal->admin_header_color) : 'navbar-light';

    if (str_contains($portal->admin_header_color, 'skin')) {
       
        $sidebar_class = str_replace("skin","sidebar-dark", $portal->admin_header_color); 
    } else {
        
        $sidebar_class = $portal->admin_sidebar_color;
    }
    
    $brand_class = $navbar_class != 'navbar-light' ? $navbar_class : '';
 ?>

 <?php
      try {
        
        $authController = new App\Http\Controllers\Auth\AuthController();

        // auth user data
        $authInfo = $authController->getLoggedInClientInfo();

        $whiteLabel = (\Event::dispatch('helpdesk.apply.whitelabel')) ? true : false;

        $tag = Config::get('app.tags');

        $version = Config::get('app.version');

      } catch(\Exception $e) {
        // ignore exception
      }
    ?>

        <style>

      .form-control { font-size: inherit !important; }

      .sidebar { overflow-y: hidden; }

      .sidebar:hover { overflow-y: auto !important; }

      #scroll-bar::-webkit-scrollbar-track
      {
        border-radius:10px;
      }

      #scroll-bar::-webkit-scrollbar
      {
        width: 6px;
      }

      #scroll-bar::-webkit-scrollbar-thumb
      {
        background-color: #7e7e7e;
        border-radius: 10px;
      }

      .sidebar-dark-black .nav-sidebar>.nav-item>.nav-link.active, .sidebar-light-black .nav-sidebar>.nav-item>.nav-link.active {
        background-color: #6c757d;
        color: #fff;
      }
    </style>
 <style type="text/css">


    .modal-backdrop.fade,.modal-backdrop.show {
    display: none;
    }

    .dropdown-item { backface-visibility: hidden; }
 
.breadcrumb-item+.breadcrumb-item::before {
 content: '>\00a0' !important; 
}

label {
    font-weight: 500 !important;
}

.card-title { font-weight: 500 !important; }

.form-control:focus { box-shadow: none !important; border-color: #ced4da !important; }


     body{
        padding-right: 0 !important;
        overflow-x: hidden;
    }

    div.dataTables_wrapper div.dataTables_processing { width: 0 !important; }

    #chumper{
      /*display: table-cell!important;*/
    }

 </style>
    <head>
        <meta charset="UTF-8">
           <?php echo $__env->yieldContent('meta-tags'); ?>

         <title> <?php echo $__env->yieldContent('title'); ?> <?php echo strip_tags($title_name); ?> </title>
        <meta name="api-base-url" content="<?php echo e(url('/')); ?>" />
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <meta name="api-base-url" content="<?php echo e(url('/')); ?>" />
        <!-- faveo favicon -->
    
        <link href="<?php echo e($portal->icon); ?>" rel="shortcut icon">
       
        <!-- Bootstrap 3.4.1 -->
        <!-- <link rel="stylesheet" href="<?php echo e(assetLink('css','bootstrap-latest')); ?>"> -->
        <!-- <link href="<?php echo e(assetLink('css','bootstrap-4')); ?>" rel="stylesheet" type="text/css" /> -->

        <!-- Font Awesome Icons -->
        <!-- <link href="<?php echo e(assetLink('css','font-awesome')); ?>" rel="stylesheet" type="text/css" /> -->
        <link href="<?php echo e(assetLink('css','font-awesome-5')); ?>" rel="stylesheet" type="text/css" />
        <!-- Ionicons -->
        <link href="<?php echo e(assetLink('css','ionicons')); ?>" rel="stylesheet" type="text/css" media="none" onload="this.media='all';">
        <!-- Theme style -->
        <link href="<?php echo e(assetLink('css','adminlte-3')); ?>" rel="stylesheet" type="text/css" id="adminLTR" media="none" onload="this.media='all';"/>

        <link rel="stylesheet" href="<?php echo e(assetLink('css','new-overlay')); ?>">

        <link rel="stylesheet" href="<?php echo e(assetLink('css','pagination')); ?>">

        <link rel="stylesheet" href="<?php echo e(assetLink('css','glyphicon')); ?>">

        <link  href="<?php echo e(assetLink('css','editor')); ?>" rel="stylesheet" type="text/css" media="none" onload="this.media='all';">
        <script src="<?php echo e(assetLink('js','jquery-3')); ?>" type="text/javascript"></script>
        <script src="<?php echo e(assetLink('js','ckeditor')); ?>"></script>
        <script src="<?php echo e(assetLink('js','polyfill')); ?>"></script>
        <style type="text/css">

.nav-sidebar .nav-header:not(:first-of-type) {
    padding-left : 0.5rem !important;
}

table.dataTable { width: -webkit-fill-available !important; }
button.close { margin-top: -4px !important; }
.modal-header h4 { margin-top: 0px !important; }

.modal-title {
  font-weight: 400 !important;
}

.custom-select-sm { font-size: 100% !important; margin: auto; }

    #lang_div{width: 290px;}

.user-panel img {
        height: 2.1rem !important;
    }
    #company_image{text-align: center !important;}
  
    .brand-image{float: none !important;margin-left: 0px !important;}

    .container-fluid { padding-bottom: 1px; }

.hide {
    display: none!important;
}

.select2-search__field {
    width: 100% !important;
}
.select2-container .select2-selection--multiple {
    height: 34px;
    border-radius: 0.25rem !important;
    border: 1px solid #d2d6de !important;
    overflow-y: auto;
}
.select2-container {
    display: block;
    width: 100%;
}
.loading {
    background-image: url(http://www.fotos-lienzo.es/media/aw_searchautocomplete/default/loading.gif);
    background-repeat: no-repeat;
}
.loading:after {
    content: "Sending...";
    text-align: right;
    padding-left: 25px;
}
.select2-selection__choice {
    color: #444 !important;
}
.list-group-item {
    margin-bottom: auto !important;
}

.color-picker-container { height: 36px !important; }

        </style>

        <?php
            use App\Model\helpdesk\Settings\Alert;
            $browser_status = false;
            $alert =  new Alert;
            $enabled = $alert->where('key', 'browser_notification_status')->value('value');
            $app_id = $alert->where('key', 'api_id')->value('value');

            $in_app_notification = $alert->where('key', 'browser-notification-status-inbuilt')->value('value');
            $in_app_notification_status = false;
            if($enabled == 1)
                $browser_status = 0;
            if($in_app_notification == 1)
                $in_app_notification_status = 1;
        ?>

         <?php if($enabled == 1): ?>
         <link rel="manifest" href="/manifest.json">
        <script src="https://cdn.onesignal.com/sdks/OneSignalSDK.js" ></script>
        <script type="text/javascript">
            var OneSignal = window.OneSignal || [];
            OneSignal.push(["init", {
                appId: "<?php echo $app_id; ?>",
                autoRegister: false,
                notifyButton: {
                    enable: "<?php echo e($browser_status); ?>" /* Set to false to hide */
                }
            }]);
            var user =  "<?php echo e(Auth::guest()); ?>";
            if(!user){
                var user_id = "<?php if(Auth::user()){ echo Auth::user()->hash_ids;} ?>";
                var user_role = "<?php if(Auth::user()){ echo Auth::user()->role;} ?>";
                var user_name = "<?php if(Auth::user()){ echo Auth::user()->user_name;} ?>";
                OneSignal.push(function() {
                    //These examples are all valid
                    OneSignal.sendTag("user_name",user_name);
                    OneSignal.sendTag("user_id", user_id);
                    OneSignal.sendTag("user_role", user_role);
                });
            }

        </script>
        <?php endif; ?>
        <script type="text/javascript" src="<?php echo e(asset('browser-detect.min.js')); ?>"></script>

        <?php echo $__env->yieldContent('HeadInclude'); ?>
        <!-- rtl brecket -->
<!--  <style type="text/css">
     *:after {
    content: "\200E‎";
}
 </style> -->
       <style>

<?php if(isPlugin('ServiceDesk')): ?>
     .content-heading-anchor{
          margin-top: -44px;
     }
<?php endif; ?>
<?php if(Lang::getLocale() == "ar"): ?>
.datepicker {
   direction: rtl;
}
.datepicker.dropdown-menu {
   right: initial;
}
<?php endif; ?>


               input[type=number]::-webkit-inner-spin-button,
               input[type=number]::-webkit-outer-spin-button {
                -webkit-appearance: none;
                -moz-appearance: none;
                appearance: none;
                margin: 0;
               }
            </style>
<?php echo $__env->yieldContent('custom-css'); ?>

<?php \Event::dispatch('customcss-event', [['fired_at' => 'adminlayout','request' => Request()]]); ?>
  </head>
  
    <body class="sidebar-mini layout-fixed layout-navbar-fixed text-sm" ng-controller="MainCtrl" style="display: none;">

        <div class="wrapper">

            <?php if($portal->admin_header_color): ?>
            <nav class="main-header navbar navbar-expand <?php echo e($navbar_class); ?>">
            <?php else: ?>
            <nav class="main-header navbar navbar-expand navbar-light">
            <?php endif; ?>

                <?php $notifications = App\Http\Controllers\Common\NotificationController::getNotifications(); ?>
              
                <ul class="navbar-nav">
                      
                    <li class="nav-item">
                    
                        <a class="nav-link" data-widget="pushmenu" href="#" role="button" onclick="togglePush()"><i class="fa fa-bars"></i></a>
                    </li>

                    <li class="nav-item d-none d-sm-inline-block" <?php echo $__env->yieldContent('settings'); ?>>

                        <a href="<?php echo e(url('panel/dashboard')); ?>" class="nav-link"><?php echo Lang::get('lang.agent_panel'); ?></a>
                    </li>
                </ul>
                  <ul class="navbar-nav ml-auto">
                    
                    <li class="nav-item d-none d-sm-inline-block">

                        <a href="<?php echo e(url('admin')); ?>" class="nav-link" onclick="removeurl()"><?php echo Lang::get('lang.admin_panel'); ?></a>
                    </li>

                    <!-- START NOTIFICATION -->
                    <?php echo $__env->make('themes.default1.inapp-notification.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <!-- END NOTIFICATION -->

                    <li class="nav-item dropdown">
                        <?php $src = Lang::getLocale().'.png'; ?>
                        <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
                            <img src="<?php echo e(assetLink('image','flag').'/'.$src); ?>" ></img>
                        </a>
                        <div class="dropdown-menu dropdown-menu-sm dropdown-menu-right p-0" id="lang_div">
                            <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $src = $key.".png";
                                ?>
                                <a href="#" class="dropdown-item" id="<?php echo e($key); ?>" onclick="changeLang(this.id)">
                                    <img src="<?php echo e(assetLink('image','flag').'/'.$src); ?>"></img>&nbsp;<?php echo e($value[0]); ?>&nbsp;
                                        <?php if(Lang::getLocale() == "ar"): ?>
                                        &rlm;
                                        <?php endif; ?>
                                        (<?php echo e($value[1]); ?>)</a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </li>

                    <?php
                           $onerrorImage = assetLink('image','contacthead');
                            ?>

                    <!-- User Account: style can be found in dropdown.less -->
                    <li class="nav-item dropdown user-menu">
                        <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">
                            <?php if(Auth::user()): ?>
                            <img src="<?php echo e(Auth::user()->profile_pic); ?>" onerror="this.src='<?php echo e($onerrorImage); ?>'" class="user-image img-circle elevation-2" alt="User Image"/>
                           <span class="d-none d-md-inline" title="<?php echo e(Auth::user()->fullname); ?>"><?php echo e((ucfirst(str_limit(Auth::user()->fullname, 15)))); ?></span>
                            <?php endif; ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                            <!-- User image -->
                            <li class="user-header bg-secondary">
                                <?php if(Auth::user()): ?>
                                <img src="<?php echo e(Auth::user()->profile_pic); ?>" onerror="this.src='<?php echo e($onerrorImage); ?>'" 
                                class="img-circle elevation-2" alt="User Image" />
                                <p title="<?php echo e(Auth::user()->fullname); ?>" style="margin-top: 0px;"><?php echo e(Auth::user()->fullname); ?>

                                    <small class="text-capitalize"><?php echo e(Auth::user()->role); ?></small>
                                </p>
                                <?php endif; ?>
                            </li>
                            <!-- Menu Footer-->
                            <li class="user-footer">
                                
                                <a href="<?php echo e(url('panel/profile')); ?>" class="btn btn-primary btn-flat"><?php echo Lang::get('lang.profile'); ?></a>
                                
                                <a href="#" class="btn btn-danger btn-flat float-right" id="logout"><?php echo Lang::get('lang.sign_out'); ?></a>
                                
                            </li>

                        </ul>

                    </li>
                </ul>
            </nav>

            <!-- Left side column. contains the logo and sidebar -->
            <aside class="main-sidebar 123 elevation-4 <?php echo e($sidebar_class); ?>">
                
            <a href="<?php echo e($company->website); ?>" class="brand-link <?php echo e($brand_class); ?>" id="company_image">

                  <img src='<?php echo e($portal->logo); ?>' class="brand-image" alt="Company Log0" style="opacity: .8">
                </a>
               
               <div id="navigation-container">

                    <admin-navigation-bar :auth="<?php echo e(json_encode($authInfo)); ?>" from="admin"></admin-navigation-bar>
               </div>
            </aside>

            <!-- Right side column. Contains the navbar and content of the page -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <div class="content-header">
                  <div class="container-fluid">
                    <div class="row mb-2">
                      <div class="col-sm-4">
                        <h1 class="m-0 text-dark"><?php echo $__env->yieldContent('PageHeader'); ?></h1>
                      </div><!-- /.col -->
                      <div class="col-sm-8">

                        <?php if(Breadcrumbs::exists()): ?>
                        <?php echo Breadcrumbs::render(); ?>

                        <?php endif; ?>
                      </div><!-- /.col -->
                    </div><!-- /.row -->
                  </div><!-- /.container-fluid -->
                </div>

                <!-- Main content -->
                <section class="content">
                    <div class="container-fluid">
                    <?php if($dummy_installation == 1 || $dummy_installation == '1'): ?>
                    <div class="alert alert-info alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <i class="icon fa  fa-exclamation-triangle"></i> <?php echo e(Lang::get('lang.dummy_data_installation_message')); ?> <a href="<?php echo e(route('clean-database')); ?>"><?php echo e(Lang::get('lang.click')); ?></a> <?php echo e(Lang::get('lang.clear-dummy-data')); ?>

                    </div>
                    <?php else: ?>
                        <?php if(!$is_mail_conigured): ?>
                            <div class="alert alert-warning">
                                <i class="fa fa-exclamation-triangle"></i>
                                <?php if(\Auth::user()->role == 'admin'): ?>
                                    <?php echo e(Lang::get('lang.system-outgoing-incoming-mail-not-configured')); ?>&nbsp;<a href="<?php echo e(URL::route('emails.create')); ?>"><?php echo e(Lang::get('lang.confihure-the-mail-now')); ?></a>
                                <?php else: ?>
                                    <?php echo e(Lang::get('lang.system-mail-not-configured-agent-message')); ?>

                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>

                    
                    <script type="text/javascript">
                        <?php
                            $user = Auth::user();
                        ?>
                        sessionStorage.setItem('full_name', '<?php echo e($user->full_name); ?>');
                        sessionStorage.setItem('profile_pic', '<?php echo $user->profile_pic; ?>');
                        sessionStorage.setItem('user_id', '<?php echo e($user->id); ?>');
                        sessionStorage.setItem('is_rtl', '<?php echo e(App::getLocale() == "ar" ? 1 : 0); ?>');
                        sessionStorage.setItem('header_color', '<?php echo e($portal->admin_header_color); ?>');
                        sessionStorage.setItem('data_time_format', '<?php echo e(dateTimeFormat()); ?>');
                        sessionStorage.setItem('date_format', '<?php echo e(dateFormat()); ?>');
                        sessionStorage.setItem('timezone', '<?php echo e(agentTimeZone()); ?>');
                        sessionStorage.setItem('user_role', '<?php echo e($user->role); ?>');
                    </script>
                    <script src="<?php echo e(bundleLink('js/lang')); ?>" type="text/javascript"></script>
                    <script src="<?php echo e(bundleLink('js/common.js')); ?>" type="text/javascript"></script>
                    <script src="<?php echo e(bundleLink('js/navigation.js')); ?>" type="text/javascript"></script>
                    <div class="custom-div-top" id="custom-div-top"></div>
                    <?php echo $__env->yieldContent('content'); ?>
                    <div class="custom-div-bottom" id="custom-div-bottom"></div>
                </div>
                </section><!-- /.content -->
                <!-- /.content-wrapper -->
            </div>



            <footer class="main-footer">


                  <?php if(!isWhiteLabelEnabled()): ?>
                <!--  <div style="position: fixed;right:0;bottom:0">
                    <button data-toggle="control-sidebar" onclick="openSlide()" style="margin-right:20px"  class="btn btn-primary helpsection">
                        <?php echo Lang::get('lang.have_a_question'); ?>

                   &nbsp;&nbsp;<i class="fa fa-question-circle" aria-hidden="true"></i></button>
                </div> -->
             <?php endif; ?>

                <div class="float-right d-none d-sm-block">

                   <?php if(isWhiteLabelEnabled()): ?>
                    <span style="font-weight: 500">Version</span> <?php echo Config::get('app.tags'); ?>


                    <?php else: ?>
                    <span style="font-weight: 500">Version</span> <?php echo Config::get('app.version'); ?>


                    <?php endif; ?>



                </div>
                <?php
                $company = App\Model\helpdesk\Settings\Company::where('id', '=', '1')->first();
                ?>
                <span style="font-weight: 500"><?php echo Lang::get('lang.copyright'); ?> &copy; <?php echo date('Y'); ?>  

                    <?php if($company->website): ?>
                    
                    <a href="<?php echo $company->website; ?>" target="_blank"><?php echo $company->company_name; ?></a>.

                    <?php else: ?>
                     <a class="text-primary"><?php echo $company->company_name; ?></a>.

                    <?php endif; ?>

                </span>

               <?php if(isWhiteLabelEnabled()): ?>
                   <?php echo Lang::get('lang.all_rights_reserved'); ?>

                <?php else: ?>
                 <?php echo Lang::get('lang.all_rights_reserved'); ?>. <?php echo Lang::get('lang.powered_by'); ?> <a href="https://www.faveohelpdesk.com/" target="_blank">Faveo</a>

                <?php endif; ?>



                 <!-- <?php echo Lang::get('lang.powered_by'); ?> <a href="http://www.faveohelpdesk.com/" target="_blank">Faveo</a> -->
            </footer>

            <?php if(!isWhiteLabelEnabled()): ?>
            <div id="help-widget">
                <help-widget :from="'admin'"></help-widget>
            </div>

            <script src="<?php echo e(bundleLink('js/helpwidget.js')); ?>" type="text/javascript"></script>
            <?php endif; ?>
        
        </div><!-- ./wrapper -->
        <script  type="text/javascript">
            localStorage.setItem('PATH', '<?php echo e(asset("/")); ?>');
            localStorage.setItem('CSRF', '<?php echo e(csrf_token()); ?>');
            localStorage.setItem('NOTI_COND', '<?php echo e($in_app_notification); ?>');
            localStorage.setItem('GUEST', '<?php echo e(Auth::guest()); ?>');
            localStorage.setItem('LANGUAGE', '<?php echo e(Lang::getLocale()); ?>');
            localStorage.setItem('PLUGIN', '<?php echo e(isPlugin()); ?>');
        </script>

        <script type="text/javascript" src="<?php echo e(assetLink('js','popper')); ?>"></script>
        <!-- Bootstrap 3.3.2 JS -->
        <script src="<?php echo e(assetLink('js','bootstrap-4')); ?>" type="text/javascript"></script>
        <!-- <script src="<?php echo e(assetLink('js','bootstrap-latest')); ?>" type="text/javascript"></script> -->

        <!-- AdminLTE App -->
        <script src="<?php echo e(assetLink('js','adminlte-3')); ?>" type="text/javascript"></script>
        <!-- iCheck -->

        <!-- select2 -->
        <script src="<?php echo e(assetLink('js','nprogress')); ?>" type="text/javascript"></script>



<?php if(isPlugin('ServiceDesk')): ?>
<script>
    $(function(){
        $('.content-heading-anchor').next().removeClass('content');
    })
</script>
<?php endif; ?>
<?php if(trim($__env->yieldContent('no-toolbar'))): ?>
    <h1><?php echo $__env->yieldContent('no-toolbar'); ?></h1>
<?php else: ?>

<?php endif; ?>
<script type="text/javascript">
    $.ajaxSetup({
        headers: { 'X-CSRF-Token' : $('meta[name=csrf-token]').attr('content') }
    });
    $('#Form').submit(function (e) {
        if ($('#mobile').parent().hasClass('has-error')) {
            var alert_msg = "<?php echo e(Lang::get('lang.please-check-mobile-number')); ?>";
            alert(alert_msg);
            e.preventDefault();
        } else {
            var $this = $('#submit');
            $this.button('loading');
            $('#Edit').modal('show');
        }

    });

    // logout click function
    $("#logout").click(function(){
    $.ajax({
        /* the route pointing to the post function */
        url: '<?php echo e(url("auth/logout")); ?>',
        type: 'POST',
        data: { "_token": "<?php echo e(csrf_token()); ?>"},
        /* remind that 'data' is the response of the AjaxController */
        success: function (response) { 
             window.location.href = response.data;
             }
        }); 
    });
</script>

<script type="text/javascript">
$(document).ready(function(){
  $('[data-toggle="tooltip"]').tooltip();
});

if(JSON.parse(localStorage.getItem('pushmenu')) == true) {
    
    document.getElementById('admin_body').classList.add('sidebar-collapse')
}

function togglePush() {

    let pushmenu = JSON.parse(localStorage.getItem("pushmenu")) == true ? false : true;

    localStorage.setItem("pushmenu", pushmenu);
}
</script>
<script src="<?php echo e(bundleLink('js/admin.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(assetLink('js','angular')); ?>" type="text/javascript"></script>
<script src="<?php echo e(assetLink('js','angular-moment')); ?>" type="text/javascript"></script>
<script src="<?php echo e(assetLink('js','bsSwitch')); ?>" type="text/javascript"></script>
<script src="<?php echo e(assetLink('js','angular-desktop-notification')); ?>" type="text/javascript"></script>

<script src="<?php echo e(assetLink('js','ui-bootstrap-tpls')); ?>"></script>
<script src="<?php echo e(assetLink('js','main')); ?>"></script>
<script src="<?php echo e(assetLink('js','handleCtrl')); ?>"></script>
<script src="<?php echo e(assetLink('js','nodeCtrl')); ?>"></script>
<script src="<?php echo e(assetLink('js','nodesCtrl')); ?>"></script>

<script src="<?php echo e(assetLink('js','treeCtrl')); ?>"></script>
<script src="<?php echo e(assetLink('js','uiTree')); ?>"></script>
<script src="<?php echo e(assetLink('js','uiTreeHandle')); ?>"></script>
<script src="<?php echo e(assetLink('js','uiTreeNode')); ?>"></script>

<script src="<?php echo e(assetLink('js','uiTreeNodes')); ?>"></script>
<script src="<?php echo e(assetLink('js','helper')); ?>"></script>
<script src="<?php echo e(assetLink('js','ng-flow-standalone')); ?>" ></script>
<script src="<?php echo e(assetLink('js','fusty-flow')); ?>" ></script>

<script src="<?php echo e(assetLink('js','fusty-flow-factory')); ?>" ></script>
<script src="<?php echo e(assetLink('js','ng-file-upload')); ?>"></script>
<script src="<?php echo e(assetLink('js','ng-file-upload-shim')); ?>"></script>
<script src="<?php echo e(assetLink('js','tw-currency-select')); ?>"></script>
<script src="<?php echo e(assetLink('js','angular-admin-script')); ?>" type="text/javascript"></script>
<script src="<?php echo e(assetLink('js','new-overlay')); ?>" type="text/javascript"></script>
<?php \Event::dispatch('timeline-customjs', [['fired_at' => 'adminlayout','request' => Request()]]); ?>
<?php \Event::dispatch('admin-panel-scripts-dispatch') ?>
<?php echo $__env->yieldContent('FooterInclude'); ?>
<?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH /home/localida/marcoquan.com/sistemadeatencionv2/resources/views/themes/default1/admin/layout/admin.blade.php ENDPATH**/ ?>