<!DOCTYPE html>
<?php
$lang = \Lang::getLocale();
$class = $lang == 'ar' ? "ar": "nonar";
?>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    	<style type="text/css">
			.ar {
				direction: rtl;
				text-align: right;
				font-family: 'dejavu sans, arial', sans-serif;
			}

			.nonar{
				font-family: 'dejavu sans, arial,', sans-serif;
				font-size: small;
			}

			.info-row{
				border-top: 1px solid #f4f4f4;
				padding: 10px;
				box-sizing: border-box;
				font-family: 'dejavu sans, arial', sans-serif;
			}

			img {
				max-width: 500px !important;
			}

            .twemoji { width: 20px;height: 20px; }
		</style>
    </head>
	<body class="<?php echo $class; ?>}">
        <?php $ticketDetails =  $ticketDetails->getData(); $ticketDetails = $ticketDetails->data->ticket; ?>
    	<h2 style="text-align: center"><u><?php echo "#".$ticketDetails->ticket_number.""; ?></u></h2>
        <br>
        <table class="result_table">
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.created_at')); ?>:</b></td><td>&nbsp;&nbsp;<?php echo faveoDate($ticketDetails->created_at); ?></td>
            </tr>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.subject')); ?>:</b></td><td>&nbsp;&nbsp;<?php echo $ticketDetails->title; ?></td>
            </tr>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.departments')); ?>:</b></td><td>&nbsp;&nbsp;<?php echo $ticketDetails->departments->name; ?></td>
            </tr>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.help_topic')); ?>:</b></td><td>&nbsp;&nbsp;<?php echo $ticketDetails->helptopic->name; ?></td>
            </tr>
            <?php if($allTicketDetails): ?>
            <?php if($ticketDetails->updated_at): ?>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.updated_at')); ?>:</b></td><td>&nbsp;&nbsp;<?php echo faveoDate($ticketDetails->updated_at); ?></td>
            </tr>    
            <?php endif; ?>
            <?php if($ticketDetails->status->name): ?>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.status')); ?>:</b></td><td>&nbsp;&nbsp;<?php echo $ticketDetails->status->name; ?></td>
            </tr>    
            <?php endif; ?>
            <?php if($ticketDetails->last_replier): ?>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.last_replier')); ?>:</b></td><td>&nbsp;&nbsp;
                    <?php if($ticketDetails->last_replier->first_name): ?>
                        <?php echo $ticketDetails->last_replier->first_name; ?>    
                    <?php endif; ?>
                    <?php if($ticketDetails->last_replier->last_name): ?>
                        <?php echo $ticketDetails->last_replier->last_name; ?>

                    <?php endif; ?>
                </td>                        
            </tr>    
            <?php endif; ?>
            <?php if($ticketDetails->user): ?>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.requester')); ?>:</b></td><td>&nbsp;&nbsp;
                    <?php if($ticketDetails->user->first_name): ?>
                        <?php echo $ticketDetails->user->first_name; ?>    
                    <?php endif; ?>
                    <?php if($ticketDetails->user->last_name): ?>
                        <?php echo $ticketDetails->user->last_name; ?>

                    <?php endif; ?>
                </td>                     
            </tr>
            <?php endif; ?>
            <?php if($ticketDetails->user): ?>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.creator')); ?>:</b></td><td>&nbsp;&nbsp;
                    <?php if($ticketDetails->user->first_name): ?>
                        <?php echo $ticketDetails->user->first_name; ?>    
                    <?php endif; ?>
                    <?php if($ticketDetails->user->last_name): ?>
                        <?php echo $ticketDetails->user->last_name; ?>   
                    <?php endif; ?>
                </td>
            </tr>    
            <?php endif; ?>
            <?php if($ticketDetails->assignee): ?>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.assignee')); ?>:</b></td><td>&nbsp;&nbsp;
                    <?php if($ticketDetails->assignee->first_name): ?>
                        <?php echo $ticketDetails->assignee->first_name; ?>    
                    <?php endif; ?>
                    <?php if($ticketDetails->assignee->last_name): ?>
                        <?php echo $ticketDetails->assignee->last_name; ?>   
                    <?php endif; ?>
                </td>
            </tr>    
            <?php endif; ?>
            <?php if($ticketDetails->source): ?>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.source')); ?>:</b></td><td>&nbsp;&nbsp;<?php echo $ticketDetails->source->name; ?></td>
            </tr>    
            <?php endif; ?>
            <?php if($ticketDetails->type): ?>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.type')); ?>:</b></td><td>&nbsp;&nbsp;<?php echo $ticketDetails->type->name; ?></td>
            </tr>
            <?php endif; ?>
            <?php if($ticketDetails->priority): ?>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.priority')); ?>:</b></td><td>&nbsp;&nbsp;<?php echo $ticketDetails->priority->name; ?></td>
            </tr>
            <?php endif; ?>
            <?php if($ticketDetails->sla_plan): ?>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.sla_plans')); ?>:</b></td><td>&nbsp;&nbsp;<?php echo $ticketDetails->sla_plan->name; ?></td>
            </tr>
            <?php endif; ?>            
            <?php if($ticketDetails->location): ?>
            <tr class="info-row">
                <td><b><?php echo e(trans('lang.location')); ?>:</b></td><td>&nbsp;&nbsp;<?php echo $ticketDetails->location->name; ?></td>
            </tr>
            <?php endif; ?>
            <?php if(count($ticketDetails->custom_field_values) > 0){ $customFields = $ticketDetails->custom_field_values; ?>
                <?php $__currentLoopData = $customFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customField): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="info-row">
                    <td><b><?php echo e($customField->label); ?>  :</b></td>
                    <td>
                        &nbsp;&nbsp;
                        <?php if(gettype($customField->value) == 'string'): ?>
                            <?php echo e($customField->value); ?>

                        <?php endif; ?>
                        <?php if(gettype($customField->value) == 'array'): ?>
                            <?php echo e(implode(', ', $customField->value)); ?>

                        <?php endif; ?>
                    </td>
                </tr>   
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php } ?>
            <?php endif; ?>
        </table>
        <br>
        <h3><?php echo trans("lang.ticket-conversation-title"); ?></h3>
        <ul>
            <?php $__currentLoopData = $ticketConversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticketConversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $name = $ticketConversation->first_name ? $ticketConversation->first_name.' '.$ticketConversation->last_name: "System";
                ?>
                <li>
                    <div style="margin-top:-2px"><?php echo trans("lang.posted_by_on", ["user"=> "<strong>".htmlentities($name)."</strong>", "time"=> faveoDate($ticketConversation->created_at)]); ?>

                    <?php if($ticketConversation->is_internal): ?>
                        (<?php echo trans("lang.as_internal_note"); ?>)
                    <?php endif; ?>
                    </div>
                    <div style="background-color: rgba(0,0,0,0.04); padding: 5px;" class="<?php echo $class; ?>"><?php echo $ticketConversation->formatted_body; ?></div>
                    <br>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
	</body>
</html>
<?php /**PATH /home/localida/marcoquan.com/sistemadeatencionv2/resources/views/themes/default1/agent/helpdesk/ticket/pdf.blade.php ENDPATH**/ ?>