<?php
        $title = App\Model\helpdesk\Settings\System::where('id','1')->value('name');
        $titleName = ($title) ? $title :"SUPPORT CENTER";
 ?>
<?php $__env->startSection('meta-tags'); ?>


<meta name="title" content="<?php echo Lang::get('lang.ratings_lists-page-title'); ?> :: <?php echo strip_tags($titleName); ?> ">

<meta name="description" content="<?php echo Lang::get('lang.ratings_lists-page-description'); ?>">


<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-css'); ?>
 <link href="<?php echo e(assetLink('css','dataTables-bootstrap')); ?>" rel="stylesheet" type="text/css" media="none" onload="this.media='all';">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('Tickets'); ?>
active
<?php $__env->stopSection(); ?>

<?php $__env->startSection('ratings'); ?>
class="active"
<?php $__env->stopSection(); ?>

<?php $__env->startSection('PageHeader'); ?>
<h1><?php echo Lang::get('lang.ratings'); ?></h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if(Session::has('success')): ?>
        <div class="alert alert-success alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <span><?php echo e(Session::get('success')); ?></span>                
        </div>
<?php endif; ?>

<?php if(Session::has('fails')): ?>
        <div class="alert alert-danger alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <span><?php echo e(Session::get('fails')); ?></span>                
        </div>
<?php endif; ?>
<div class="card card-light">
    <div class="card-header">
        <h3 class="card-title"><?php echo Lang::get('lang.list_of_current_ratings'); ?></h3>
        <div class="card-tools">
             <a href="<?php echo e(route('rating.create')); ?>" class="btn btn-tool" title="<?php echo e(Lang::get('lang.create_rating')); ?>" data-toggle="tooltip"><span class="glyphicon glyphicon-plus"></span>

             </a>

        </div><!-- /.box-header -->
    </div>
    <div class="card-body">
       
        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th><?php echo Lang::get('lang.name'); ?></th>
                    <th><?php echo Lang::get('lang.display_order'); ?></th>
                    <th><?php echo Lang::get('lang.rating_area'); ?></th>
                    <th><?php echo Lang::get('lang.action'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $ratings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rating): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo $rating->name; ?></td>                                                    
                    <td><?php echo $rating->display_order; ?></td>
                    <td><?php echo $rating->rating_area; ?></td>
                    <td>
                        <a href="<?php echo e(url('editratings/'.$rating->id)); ?>" class="btn btn-primary btn-xs "><i class="fas fa-edit" style="color:white;">&nbsp;</i>Edit</a>&nbsp;
                        
                        <button class="btn btn-primary btn-xs" data-toggle="modal" data-target="#delete-<?php echo e($rating->id); ?>"><i class="fas fa-trash" style="color:white;"></i>&nbsp;Delete</button>
                        <div class="modal fade" id="delete-<?php echo e($rating->id); ?>">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        
                                        <h4 class="modal-title"><?php echo Lang::get('lang.delete'); ?></h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                    </div>
                                    <div class="modal-body">
                                        <span><?php echo Lang::get('lang.are_you_sure'); ?> </span>
                                    </div>
                                    <div class="modal-footer justify-content-between">
                                        <button type="button" class="btn btn-default" data-dismiss="modal"><i class="fas fa-times" aria-hidden="true">&nbsp;</i><?php echo Lang::get('lang.close'); ?></button>
                                             <?php
                                                $url=url('deleter/'.$rating->id);
                                              ?>
                                             <a href="<?php echo $url; ?>" class="btn btn-danger"><i class="fas fa-trash" aria-hidden="true">&nbsp;</i><?php echo Lang::get('lang.delete'); ?></a>
                                    </div>
                                </div> 
                            </div>
                        </div> 
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div><!-- /.box-body -->
</div>
<script src="<?php echo e(assetLink('js','jquery-dataTables')); ?>" type="text/javascript"></script>
<script src="<?php echo e(assetLink('js','dataTables-bootstrap')); ?>"  type="text/javascript"></script>

<!-- page script -->
<script type="text/javascript">
$(function() {
    $("#example1").dataTable();
    // $('#example2').dataTable({
    //     "bPaginate": true,
    //     "bLengthChange": false,
    //     "bFilter": false,
    //     "bSort": true,
    //     "bInfo": true,
    //     "bAutoWidth": false
    // });
});

</script>

<script type="text/javascript">
<?php if (count($errors) > 0) { ?>
        $('#create').modal('show');
<?php } ?>
</script>  
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('themes.default1.admin.layout.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/localida/marcoquan.com/sistemadeatencionv2/resources/views/themes/default1/admin/helpdesk/settings/ratings.blade.php ENDPATH**/ ?>