/*!
 * Chart.js
 * http://chartjs.org/
 * Version: 1.1.1
 *
 * Copyright 2015 Nick Downie
 * Released under the MIT license
 * https://github.com/nnnick/Chart.js/blob/master/LICENSE.md
 */
(function(){var ar=this,ai=ar.Chart;var al=function(d){var c=this;this.canvas=d.canvas;this.ctx=d;var e=function(g,f){if(g["offset"+f]){return g["offset"+f]}else{return document.defaultView.getComputedStyle(g).getPropertyValue(f)}};var b=this.width=e(d.canvas,"Width")||d.canvas.width;var a=this.height=e(d.canvas,"Height")||d.canvas.height;this.aspectRatio=this.width/this.height;ak.retinaScale(this);return this};al.defaults={global:{animation:true,animationSteps:60,animationEasing:"easeOutQuart",showScale:true,scaleOverride:false,scaleSteps:null,scaleStepWidth:null,scaleStartValue:null,scaleLineColor:"rgba(0,0,0,.1)",scaleLineWidth:1,scaleShowLabels:true,scaleLabel:"<%=value%>",scaleIntegersOnly:true,scaleBeginAtZero:false,scaleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",scaleFontSize:12,scaleFontStyle:"normal",scaleFontColor:"#666",responsive:false,maintainAspectRatio:true,showTooltips:true,customTooltips:false,tooltipEvents:["mousemove","touchstart","touchmove","mouseout"],tooltipFillColor:"rgba(0,0,0,0.8)",tooltipFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipFontSize:14,tooltipFontStyle:"normal",tooltipFontColor:"#fff",tooltipTitleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipTitleFontSize:14,tooltipTitleFontStyle:"bold",tooltipTitleFontColor:"#fff",tooltipTitleTemplate:"<%= label%>",tooltipYPadding:6,tooltipXPadding:6,tooltipCaretSize:8,tooltipCornerRadius:6,tooltipXOffset:10,tooltipTemplate:"<%if (label){%><%=label%>: <%}%><%= value %>",multiTooltipTemplate:"<%= datasetLabel %>: <%= value %>",multiTooltipKeyBackground:"#fff",segmentColorDefault:["#A6CEE3","#1F78B4","#B2DF8A","#33A02C","#FB9A99","#E31A1C","#FDBF6F","#FF7F00","#CAB2D6","#6A3D9A","#B4B482","#B15928"],segmentHighlightColorDefaults:["#CEF6FF","#47A0DC","#DAFFB2","#5BC854","#FFC2C1","#FF4244","#FFE797","#FFA728","#F2DAFE","#9265C2","#DCDCAA","#D98150"],onAnimationProgress:function(){},onAnimationComplete:function(){}}};al.types={};var ak=al.helpers={};var ae=ak.each=function(d,b,f){var a=Array.prototype.slice.call(arguments,3);if(d){if(d.length===+d.length){var e;for(e=0;e<d.length;e++){b.apply(f,[d[e],e].concat(a))}}else{for(var c in d){b.apply(f,[d[c],c].concat(a))}}}},au=ak.clone=function(b){var a={};ae(b,function(c,d){if(b.hasOwnProperty(d)){a[d]=c}});return a},aA=ak.extend=function(a){ae(Array.prototype.slice.call(arguments,1),function(b){ae(b,function(c,d){if(b.hasOwnProperty(d)){a[d]=c}})});return a},ag=ak.merge=function(b,c){var a=Array.prototype.slice.call(arguments,0);a.unshift({});return aA.apply(null,a)},ax=ak.indexOf=function(a,b){if(Array.prototype.indexOf){return a.indexOf(b)}else{for(var c=0;c<a.length;c++){if(a[c]===b){return c}}return -1}},aG=ak.where=function(b,c){var a=[];ak.each(b,function(d){if(c(d)){a.push(d)}});return a},aO=ak.findNextWhere=function(a,c,b){if(!b){b=-1}for(var d=b+1;d<a.length;d++){var e=a[d];if(c(e)){return e}}},ao=ak.findPreviousWhere=function(a,c,b){if(!b){b=a.length}for(var d=b-1;d>=0;d--){var e=a[d];if(c(e)){return e}}},aL=ak.inherits=function(d){var a=this;var c=(d&&d.hasOwnProperty("constructor"))?d.constructor:function(){return a.apply(this,arguments)};var b=function(){this.constructor=c};b.prototype=a.prototype;c.prototype=new b();c.extend=aL;if(d){aA(c.prototype,d)}c.__super__=a.prototype;return c},ab=ak.noop=function(){},aJ=ak.uid=(function(){var a=0;return function(){return"chart-"+a++}})(),aB=ak.warn=function(a){if(window.console&&typeof window.console.warn==="function"){console.warn(a)}},aI=ak.amd=(typeof define==="function"&&define.amd),X=ak.isNumber=function(a){return !isNaN(parseFloat(a))&&isFinite(a)},at=ak.max=function(a){return Math.max.apply(Math,a)},Y=ak.min=function(a){return Math.min.apply(Math,a)},aj=ak.cap=function(a,b,c){if(X(b)){if(a>b){return b}}else{if(X(c)){if(a<c){return c}}}return a},am=ak.getDecimalPlaces=function(a){if(a%1!==0&&X(a)){var c=a.toString();if(c.indexOf("e-")<0){return c.split(".")[1].length}else{if(c.indexOf(".")<0){return parseInt(c.split("e-")[1])}else{var b=c.split(".")[1].split("e-");return b[0].length+parseInt(b[1])}}}else{return 0}},af=ak.radians=function(a){return a*(Math.PI/180)},aS=ak.getAngleFromPoint=function(d,f){var c=f.x-d.x,a=f.y-d.y,e=Math.sqrt(c*c+a*a);var b=Math.PI*2+Math.atan2(a,c);if(c<0&&a<0){b+=Math.PI*2}return{angle:b,distance:e}},aC=ak.aliasPixel=function(a){return(a%2===0)?0:0.5},aR=ak.splineCurve=function(h,f,c,a){var d=Math.sqrt(Math.pow(f.x-h.x,2)+Math.pow(f.y-h.y,2)),b=Math.sqrt(Math.pow(c.x-f.x,2)+Math.pow(c.y-f.y,2)),e=a*d/(d+b),g=a*b/(d+b);return{inner:{x:f.x-e*(c.x-h.x),y:f.y-e*(c.y-h.y)},outer:{x:f.x+g*(c.x-h.x),y:f.y+g*(c.y-h.y)}}},Z=ak.calculateOrderOfMagnitude=function(a){return Math.floor(Math.log(a)/Math.LN10)},aF=ak.calculateScaleRange=function(r,c,k,j,q){var i=2,f=Math.floor(c/(k*1.5)),a=(i>=f);var d=[];ae(r,function(s){s==null||d.push(s)});var l=Y(d),h=at(d);if(h===l){h+=0.5;if(l>=0.5&&!j){l-=0.5}else{h+=0.5}}var n=Math.abs(h-l),g=Z(n),m=Math.ceil(h/(1*Math.pow(10,g)))*Math.pow(10,g),o=(j)?0:Math.floor(l/(1*Math.pow(10,g)))*Math.pow(10,g),b=m-o,p=Math.pow(10,g),e=Math.round(b/p);while((e>f||(e*2)<f)&&!a){if(e>f){p*=2;e=Math.round(b/p);if(e%1!==0){a=true}}else{if(q&&g>=0){if(p/2%1===0){p/=2;e=Math.round(b/p)}else{break}}else{p/=2;e=Math.round(b/p)}}}if(a){e=i;p=b/e}return{steps:e,stepValue:p,min:o,max:o+(e*p)}},aK=ak.template=function(b,c){if(b instanceof Function){return b(c)}var d={};function a(e,f){var g=!/\W/.test(e)?d[e]=d[e]:new Function("obj","var p=[],print=function(){p.push.apply(p,arguments);};with(obj){p.push('"+e.replace(/[\r\t\n]/g," ").split("<%").join("\t").replace(/((^|%>)[^\t]*)'/g,"$1\r").replace(/\t=(.*?)%>/g,"',$1,'").split("\t").join("');").split("%>").join("p.push('").split("\r").join("\\'")+"');}return p.join('');");return f?g(f):g}return a(b,c)},ay=ak.generateLabels=function(c,e,b,a){var d=new Array(e);if(c){ae(d,function(f,g){d[g]=aK(c,{value:(b+(a*(g+1)))})})}return d},ad=ak.easingEffects={linear:function(a){return a},easeInQuad:function(a){return a*a},easeOutQuad:function(a){return -1*a*(a-2)},easeInOutQuad:function(a){if((a/=1/2)<1){return 1/2*a*a}return -1/2*((--a)*(a-2)-1)},easeInCubic:function(a){return a*a*a},easeOutCubic:function(a){return 1*((a=a/1-1)*a*a+1)},easeInOutCubic:function(a){if((a/=1/2)<1){return 1/2*a*a*a}return 1/2*((a-=2)*a*a+2)},easeInQuart:function(a){return a*a*a*a},easeOutQuart:function(a){return -1*((a=a/1-1)*a*a*a-1)},easeInOutQuart:function(a){if((a/=1/2)<1){return 1/2*a*a*a*a}return -1/2*((a-=2)*a*a*a-2)},easeInQuint:function(a){return 1*(a/=1)*a*a*a*a},easeOutQuint:function(a){return 1*((a=a/1-1)*a*a*a*a+1)},easeInOutQuint:function(a){if((a/=1/2)<1){return 1/2*a*a*a*a*a}return 1/2*((a-=2)*a*a*a*a+2)},easeInSine:function(a){return -1*Math.cos(a/1*(Math.PI/2))+1},easeOutSine:function(a){return 1*Math.sin(a/1*(Math.PI/2))},easeInOutSine:function(a){return -1/2*(Math.cos(Math.PI*a/1)-1)},easeInExpo:function(a){return(a===0)?1:1*Math.pow(2,10*(a/1-1))},easeOutExpo:function(a){return(a===1)?1:1*(-Math.pow(2,-10*a/1)+1)},easeInOutExpo:function(a){if(a===0){return 0}if(a===1){return 1}if((a/=1/2)<1){return 1/2*Math.pow(2,10*(a-1))}return 1/2*(-Math.pow(2,-10*--a)+2)},easeInCirc:function(a){if(a>=1){return a}return -1*(Math.sqrt(1-(a/=1)*a)-1)},easeOutCirc:function(a){return 1*Math.sqrt(1-(a=a/1-1)*a)},easeInOutCirc:function(a){if((a/=1/2)<1){return -1/2*(Math.sqrt(1-a*a)-1)}return 1/2*(Math.sqrt(1-(a-=2)*a)+1)},easeInElastic:function(d){var c=1.70158;var b=0;var a=1;if(d===0){return 0}if((d/=1)==1){return 1}if(!b){b=1*0.3}if(a<Math.abs(1)){a=1;c=b/4}else{c=b/(2*Math.PI)*Math.asin(1/a)}return -(a*Math.pow(2,10*(d-=1))*Math.sin((d*1-c)*(2*Math.PI)/b))},easeOutElastic:function(d){var c=1.70158;var b=0;var a=1;if(d===0){return 0}if((d/=1)==1){return 1}if(!b){b=1*0.3}if(a<Math.abs(1)){a=1;c=b/4}else{c=b/(2*Math.PI)*Math.asin(1/a)}return a*Math.pow(2,-10*d)*Math.sin((d*1-c)*(2*Math.PI)/b)+1},easeInOutElastic:function(d){var c=1.70158;var b=0;var a=1;if(d===0){return 0}if((d/=1/2)==2){return 1}if(!b){b=1*(0.3*1.5)}if(a<Math.abs(1)){a=1;c=b/4}else{c=b/(2*Math.PI)*Math.asin(1/a)}if(d<1){return -0.5*(a*Math.pow(2,10*(d-=1))*Math.sin((d*1-c)*(2*Math.PI)/b))}return a*Math.pow(2,-10*(d-=1))*Math.sin((d*1-c)*(2*Math.PI)/b)*0.5+1},easeInBack:function(a){var b=1.70158;return 1*(a/=1)*a*((b+1)*a-b)},easeOutBack:function(a){var b=1.70158;return 1*((a=a/1-1)*a*((b+1)*a+b)+1)},easeInOutBack:function(a){var b=1.70158;if((a/=1/2)<1){return 1/2*(a*a*(((b*=(1.525))+1)*a-b))}return 1/2*((a-=2)*a*(((b*=(1.525))+1)*a+b)+2)},easeInBounce:function(a){return 1-ad.easeOutBounce(1-a)},easeOutBounce:function(a){if((a/=1)<(1/2.75)){return 1*(7.5625*a*a)}else{if(a<(2/2.75)){return 1*(7.5625*(a-=(1.5/2.75))*a+0.75)}else{if(a<(2.5/2.75)){return 1*(7.5625*(a-=(2.25/2.75))*a+0.9375)}else{return 1*(7.5625*(a-=(2.625/2.75))*a+0.984375)}}}},easeInOutBounce:function(a){if(a<1/2){return ad.easeInBounce(a*2)*0.5}return ad.easeOutBounce(a*2-1)*0.5+1*0.5}},aP=ak.requestAnimFrame=(function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(a){return window.setTimeout(a,1000/60)}})(),ac=ak.cancelAnimFrame=(function(){return window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.mozCancelAnimationFrame||window.oCancelAnimationFrame||window.msCancelAnimationFrame||function(a){return window.clearTimeout(a,1000/60)}})(),aq=ak.animationLoop=function(i,e,a,h,b,f){var d=0,g=ad[a]||ad.linear;var c=function(){d++;var j=d/e;var k=g(j);i.call(f,k,j,d);h.call(f,k,j);if(d<e){f.animationFrame=aP(c)}else{b.apply(f)}};aP(c)},ap=ak.getRelativePosition=function(a){var d,c;var b=a.originalEvent||a,e=a.currentTarget||a.srcElement,f=e.getBoundingClientRect();if(b.touches){d=b.touches[0].clientX-f.left;c=b.touches[0].clientY-f.top}else{d=b.clientX-f.left;c=b.clientY-f.top}return{x:d,y:c}},aD=ak.addEvent=function(c,a,b){if(c.addEventListener){c.addEventListener(a,b)}else{if(c.attachEvent){c.attachEvent("on"+a,b)}else{c["on"+a]=b}}},aQ=ak.removeEvent=function(b,a,c){if(b.removeEventListener){b.removeEventListener(a,c,false)}else{if(b.detachEvent){b.detachEvent("on"+a,c)}else{b["on"+a]=ab}}},aa=ak.bindEvents=function(a,b,c){if(!a.events){a.events={}}ae(b,function(d){a.events[d]=function(){c.apply(a,arguments)};aD(a.chart.canvas,d,a.events[d])})},W=ak.unbindEvents=function(a,b){ae(b,function(c,d){aQ(a.chart.canvas,d,c)})},az=ak.getMaximumWidth=function(c){var a=c.parentNode,b=parseInt(ah(a,"padding-left"))+parseInt(ah(a,"padding-right"));return a?a.clientWidth-b:0},aE=ak.getMaximumHeight=function(c){var a=c.parentNode,b=parseInt(ah(a,"padding-bottom"))+parseInt(ah(a,"padding-top"));return a?a.clientHeight-b:0},ah=ak.getStyle=function(a,b){return a.currentStyle?a.currentStyle[b]:document.defaultView.getComputedStyle(a,null).getPropertyValue(b)},av=ak.getMaximumSize=ak.getMaximumWidth,aM=ak.retinaScale=function(b){var d=b.ctx,c=b.canvas.width,a=b.canvas.height;if(window.devicePixelRatio){d.canvas.style.width=c+"px";d.canvas.style.height=a+"px";d.canvas.height=a*window.devicePixelRatio;d.canvas.width=c*window.devicePixelRatio;d.scale(window.devicePixelRatio,window.devicePixelRatio)}},an=ak.clear=function(a){a.ctx.clearRect(0,0,a.width,a.height)},aN=ak.fontString=function(c,b,a){return b+" "+c+"px "+a},aw=ak.longestText=function(a,d,b){a.font=d;var c=0;ae(b,function(f){var e=a.measureText(f).width;c=(e>c)?e:c});return c},aH=ak.drawRoundedRectangle=function(d,e,b,c,f,a){d.beginPath();d.moveTo(e+a,b);d.lineTo(e+c-a,b);d.quadraticCurveTo(e+c,b,e+c,b+a);d.lineTo(e+c,b+f-a);d.quadraticCurveTo(e+c,b+f,e+c-a,b+f);d.lineTo(e+a,b+f);d.quadraticCurveTo(e,b+f,e,b+f-a);d.lineTo(e,b+a);d.quadraticCurveTo(e,b,e+a,b);d.closePath()};al.instances={};al.Type=function(b,a,c){this.options=a;this.chart=c;this.id=aJ();al.instances[this.id]=this;if(a.responsive){this.resize()}this.initialize.call(this,b)};aA(al.Type.prototype,{initialize:function(){return this},clear:function(){an(this.chart);return this},stop:function(){al.animationService.cancelAnimation(this);return this},resize:function(b){this.stop();var d=this.chart.canvas,c=az(this.chart.canvas),a=this.options.maintainAspectRatio?c/this.chart.aspectRatio:aE(this.chart.canvas);d.width=this.chart.width=c;d.height=this.chart.height=a;aM(this.chart);if(typeof b==="function"){b.apply(this,Array.prototype.slice.call(arguments,1))}return this},reflow:ab,render:function(a){if(a){this.reflow()}if(this.options.animation&&!a){var b=new al.Animation();b.numSteps=this.options.animationSteps;b.easing=this.options.animationEasing;b.render=function(f,d){var c=ak.easingEffects[d.easing];var e=d.currentStep/d.numSteps;var g=c(e);f.draw(g,e,d.currentStep)};b.onAnimationProgress=this.options.onAnimationProgress;b.onAnimationComplete=this.options.onAnimationComplete;al.animationService.addAnimation(this,b)}else{this.draw();this.options.onAnimationComplete.call(this)}return this},generateLegend:function(){return ak.template(this.options.legendTemplate,this)},destroy:function(){this.stop();this.clear();W(this,this.events);var a=this.chart.canvas;a.width=this.chart.width;a.height=this.chart.height;if(a.style.removeProperty){a.style.removeProperty("width");a.style.removeProperty("height")}else{a.style.removeAttribute("width");a.style.removeAttribute("height")}delete al.instances[this.id]},showTooltip:function(d,c){if(typeof this.activeElements==="undefined"){this.activeElements=[]}var g=(function(j){var k=false;if(j.length!==this.activeElements.length){k=true;return k}ae(j,function(l,m){if(l!==this.activeElements[m]){k=true}},this);return k}).call(this,d);if(!g&&!c){return}else{this.activeElements=d}this.draw();if(this.options.customTooltips){this.options.customTooltips(false)}if(d.length>0){if(this.datasets&&this.datasets.length>1){var h,i;for(var b=this.datasets.length-1;b>=0;b--){h=this.datasets[b].points||this.datasets[b].bars||this.datasets[b].segments;i=ax(h,d[0]);if(i!==-1){break}}var a=[],e=[],f=(function(m){var r=[],l,j=[],o=[],n,p,q,k;ak.each(this.datasets,function(s){l=s.points||s.bars||s.segments;if(l[i]&&l[i].hasValue()){r.push(l[i])}});ak.each(r,function(s){j.push(s.x);o.push(s.y);a.push(ak.template(this.options.multiTooltipTemplate,s));e.push({fill:s._saved.fillColor||s.fillColor,stroke:s._saved.strokeColor||s.strokeColor})},this);k=Y(o);p=at(o);q=Y(j);n=at(j);return{x:(q>this.chart.width/2)?q:n,y:(k+p)/2}}).call(this,i);new al.MultiTooltip({x:f.x,y:f.y,xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,xOffset:this.options.tooltipXOffset,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,titleTextColor:this.options.tooltipTitleFontColor,titleFontFamily:this.options.tooltipTitleFontFamily,titleFontStyle:this.options.tooltipTitleFontStyle,titleFontSize:this.options.tooltipTitleFontSize,cornerRadius:this.options.tooltipCornerRadius,labels:a,legendColors:e,legendColorBackground:this.options.multiTooltipKeyBackground,title:aK(this.options.tooltipTitleTemplate,d[0]),chart:this.chart,ctx:this.chart.ctx,custom:this.options.customTooltips}).draw()}else{ae(d,function(k){var j=k.tooltipPosition();new al.Tooltip({x:Math.round(j.x),y:Math.round(j.y),xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,caretHeight:this.options.tooltipCaretSize,cornerRadius:this.options.tooltipCornerRadius,text:aK(this.options.tooltipTemplate,k),chart:this.chart,custom:this.options.customTooltips}).draw()},this)}}return this},toBase64Image:function(){return this.chart.canvas.toDataURL.apply(this.chart.canvas,arguments)}});al.Type.extend=function(c){var b=this;var d=function(){return b.apply(this,arguments)};d.prototype=au(b.prototype);aA(d.prototype,c);d.extend=al.Type.extend;if(c.name||b.prototype.name){var e=c.name||b.prototype.name;var a=(al.defaults[b.prototype.name])?au(al.defaults[b.prototype.name]):{};al.defaults[e]=aA(a,c.defaults);al.types[e]=d;al.prototype[e]=function(f,g){var h=ag(al.defaults.global,al.defaults[e],g||{});return new d(f,h,this)}}else{aB("Name not provided for this chart, so it hasn't been registered")}return b};al.Element=function(a){aA(this,a);this.initialize.apply(this,arguments);this.save()};aA(al.Element.prototype,{initialize:function(){},restore:function(a){if(!a){aA(this,this._saved)}else{ae(a,function(b){this[b]=this._saved[b]},this)}return this},save:function(){this._saved=au(this);delete this._saved._saved;return this},update:function(a){ae(a,function(b,c){this._saved[c]=this[c];this[c]=b},this);return this},transition:function(a,b){ae(a,function(c,d){this[d]=((c-this._saved[d])*b)+this._saved[d]},this);return this},tooltipPosition:function(){return{x:this.x,y:this.y}},hasValue:function(){return X(this.value)}});al.Element.extend=aL;al.Point=al.Element.extend({display:true,inRange:function(a,b){var c=this.hitDetectionRadius+this.radius;return((Math.pow(a-this.x,2)+Math.pow(b-this.y,2))<Math.pow(c,2))},draw:function(){if(this.display){var a=this.ctx;a.beginPath();a.arc(this.x,this.y,this.radius,0,Math.PI*2);a.closePath();a.strokeStyle=this.strokeColor;a.lineWidth=this.strokeWidth;a.fillStyle=this.fillColor;a.fill();a.stroke()}}});al.Arc=al.Element.extend({inRange:function(h,b){var a=ak.getAngleFromPoint(this,{x:h,y:b});var g=a.angle%(Math.PI*2),f=(Math.PI*2+this.startAngle)%(Math.PI*2),e=(Math.PI*2+this.endAngle)%(Math.PI*2)||360;var c=(e<f)?g<=e||g>=f:g>=f&&g<=e;var d=(a.distance>=this.innerRadius&&a.distance<=this.outerRadius);return(c&&d)},tooltipPosition:function(){var a=this.startAngle+((this.endAngle-this.startAngle)/2),b=(this.outerRadius-this.innerRadius)/2+this.innerRadius;return{x:this.x+(Math.cos(a)*b),y:this.y+(Math.sin(a)*b)}},draw:function(b){var c=b||1;var a=this.ctx;a.beginPath();a.arc(this.x,this.y,this.outerRadius<0?0:this.outerRadius,this.startAngle,this.endAngle);a.arc(this.x,this.y,this.innerRadius<0?0:this.innerRadius,this.endAngle,this.startAngle,true);a.closePath();a.strokeStyle=this.strokeColor;a.lineWidth=this.strokeWidth;a.fillStyle=this.fillColor;a.fill();a.lineJoin="bevel";if(this.showStroke){a.stroke()}}});al.Rectangle=al.Element.extend({draw:function(){var a=this.ctx,b=this.width/2,e=this.x-b,f=this.x+b,d=this.base-(this.base-this.y),c=this.strokeWidth/2;if(this.showStroke){e+=c;f-=c;d+=c}a.beginPath();a.fillStyle=this.fillColor;a.strokeStyle=this.strokeColor;a.lineWidth=this.strokeWidth;a.moveTo(e,this.base);a.lineTo(e,d);a.lineTo(f,d);a.lineTo(f,this.base);a.fill();if(this.showStroke){a.stroke()}},height:function(){return this.base-this.y},inRange:function(a,b){return(a>=this.x-this.width/2&&a<=this.x+this.width/2)&&(b>=this.y&&b<=this.base)}});al.Animation=al.Element.extend({currentStep:null,numSteps:60,easing:"",render:null,onAnimationProgress:null,onAnimationComplete:null,});al.Tooltip=al.Element.extend({draw:function(){var e=this.chart.ctx;e.font=aN(this.fontSize,this.fontStyle,this.fontFamily);this.xAlign="center";this.yAlign="above";var f=this.caretPadding=2;var d=e.measureText(this.text).width+2*this.xPadding,g=this.fontSize+2*this.yPadding,c=g+this.caretHeight+f;if(this.x+d/2>this.chart.width){this.xAlign="left"}else{if(this.x-d/2<0){this.xAlign="right"}}if(this.y-c<0){this.yAlign="below"}var a=this.x-d/2,b=this.y-c;e.fillStyle=this.fillColor;if(this.custom){this.custom(this)}else{switch(this.yAlign){case"above":e.beginPath();e.moveTo(this.x,this.y-f);e.lineTo(this.x+this.caretHeight,this.y-(f+this.caretHeight));e.lineTo(this.x-this.caretHeight,this.y-(f+this.caretHeight));e.closePath();e.fill();break;case"below":b=this.y+f+this.caretHeight;e.beginPath();e.moveTo(this.x,this.y+f);e.lineTo(this.x+this.caretHeight,this.y+f+this.caretHeight);e.lineTo(this.x-this.caretHeight,this.y+f+this.caretHeight);e.closePath();e.fill();break}switch(this.xAlign){case"left":a=this.x-d+(this.cornerRadius+this.caretHeight);break;case"right":a=this.x-(this.cornerRadius+this.caretHeight);break}aH(e,a,b,d,g,this.cornerRadius);e.fill();e.fillStyle=this.textColor;e.textAlign="center";e.textBaseline="middle";e.fillText(this.text,a+d/2,b+g/2)}}});al.MultiTooltip=al.Element.extend({initialize:function(){this.font=aN(this.fontSize,this.fontStyle,this.fontFamily);this.titleFont=aN(this.titleFontSize,this.titleFontStyle,this.titleFontFamily);this.titleHeight=this.title?this.titleFontSize*1.5:0;this.height=(this.labels.length*this.fontSize)+((this.labels.length-1)*(this.fontSize/2))+(this.yPadding*2)+this.titleHeight;this.ctx.font=this.titleFont;var b=this.ctx.measureText(this.title).width,d=aw(this.ctx,this.font,this.labels)+this.fontSize+3,c=at([d,b]);this.width=c+(this.xPadding*2);var a=this.height/2;if(this.y-a<0){this.y=a}else{if(this.y+a>this.chart.height){this.y=this.chart.height-a}}if(this.x>this.chart.width/2){this.x-=this.xOffset+this.width}else{this.x+=this.xOffset}},getLineHeight:function(a){var b=this.y-(this.height/2)+this.yPadding,c=a-1;if(a===0){return b+this.titleHeight/3}else{return b+((this.fontSize*1.5*c)+this.fontSize/2)+this.titleHeight}},draw:function(){if(this.custom){this.custom(this)}else{aH(this.ctx,this.x,this.y-this.height/2,this.width,this.height,this.cornerRadius);var a=this.ctx;a.fillStyle=this.fillColor;a.fill();a.closePath();a.textAlign="left";a.textBaseline="middle";a.fillStyle=this.titleTextColor;a.font=this.titleFont;a.fillText(this.title,this.x+this.xPadding,this.getLineHeight(0));a.font=this.font;ak.each(this.labels,function(b,c){a.fillStyle=this.textColor;a.fillText(b,this.x+this.xPadding+this.fontSize+3,this.getLineHeight(c+1));a.fillStyle=this.legendColorBackground;a.fillRect(this.x+this.xPadding,this.getLineHeight(c+1)-this.fontSize/2,this.fontSize,this.fontSize);a.fillStyle=this.legendColors[c].fill;a.fillRect(this.x+this.xPadding,this.getLineHeight(c+1)-this.fontSize/2,this.fontSize,this.fontSize)},this)}}});al.Scale=al.Element.extend({initialize:function(){this.fit()},buildYLabels:function(){this.yLabels=[];var b=am(this.stepValue);for(var a=0;a<=this.steps;a++){this.yLabels.push(aK(this.templateString,{value:(this.min+(a*this.stepValue)).toFixed(b)}))}this.yLabelWidth=(this.display&&this.showLabels)?aw(this.ctx,this.font,this.yLabels)+10:0},addXLabel:function(a){this.xLabels.push(a);this.valuesCount++;this.fit()},removeXLabel:function(){this.xLabels.shift();this.valuesCount--;this.fit()},fit:function(){this.startPoint=(this.display)?this.fontSize:0;this.endPoint=(this.display)?this.height-(this.fontSize*1.5)-5:this.height;this.startPoint+=this.padding;this.endPoint-=this.padding;var b=this.endPoint;var c=this.endPoint-this.startPoint,a;this.calculateYRange(c);this.buildYLabels();this.calculateXLabelRotation();while((c>this.endPoint-this.startPoint)){c=this.endPoint-this.startPoint;a=this.yLabelWidth;this.calculateYRange(c);this.buildYLabels();if(a<this.yLabelWidth){this.endPoint=b;this.calculateXLabelRotation()}}},calculateXLabelRotation:function(){this.ctx.font=this.font;var g=this.ctx.measureText(this.xLabels[0]).width,a=this.ctx.measureText(this.xLabels[this.xLabels.length-1]).width,h,b;this.xScalePaddingRight=a/2+3;this.xScalePaddingLeft=(g/2>this.yLabelWidth)?g/2:this.yLabelWidth;this.xLabelRotation=0;if(this.display){var f=aw(this.ctx,this.font,this.xLabels),c,e;this.xLabelWidth=f;var d=Math.floor(this.calculateX(1)-this.calculateX(0))-6;while((this.xLabelWidth>d&&this.xLabelRotation===0)||(this.xLabelWidth>d&&this.xLabelRotation<=90&&this.xLabelRotation>0)){c=Math.cos(af(this.xLabelRotation));h=c*g;b=c*a;if(h+this.fontSize/2>this.yLabelWidth){this.xScalePaddingLeft=h+this.fontSize/2}this.xScalePaddingRight=this.fontSize/2;this.xLabelRotation++;this.xLabelWidth=c*f}if(this.xLabelRotation>0){this.endPoint-=Math.sin(af(this.xLabelRotation))*f+3}}else{this.xLabelWidth=0;this.xScalePaddingRight=this.padding;this.xScalePaddingLeft=this.padding}},calculateYRange:ab,drawingArea:function(){return this.startPoint-this.endPoint},calculateY:function(b){var a=this.drawingArea()/(this.min-this.max);return this.endPoint-(a*(b-this.min))},calculateX:function(d){var c=(this.xLabelRotation>0),e=this.width-(this.xScalePaddingLeft+this.xScalePaddingRight),a=e/Math.max((this.valuesCount-((this.offsetGridLines)?0:1)),1),b=(a*d)+this.xScalePaddingLeft;if(this.offsetGridLines){b+=(a/2)}return Math.round(b)},update:function(a){ak.extend(this,a);this.fit()},draw:function(){var a=this.ctx,c=(this.endPoint-this.startPoint)/this.steps,b=Math.round(this.xScalePaddingLeft);if(this.display){a.fillStyle=this.textColor;a.font=this.font;ae(this.yLabels,function(f,h){var e=this.endPoint-(c*h),d=Math.round(e),g=this.showHorizontalLines;a.textAlign="right";a.textBaseline="middle";if(this.showLabels){a.fillText(f,b-10,e)}if(h===0&&!g){g=true}if(g){a.beginPath()}if(h>0){a.lineWidth=this.gridLineWidth;a.strokeStyle=this.gridLineColor}else{a.lineWidth=this.lineWidth;a.strokeStyle=this.lineColor}d+=ak.aliasPixel(a.lineWidth);if(g){a.moveTo(b,d);a.lineTo(this.width,d);a.stroke();a.closePath()}a.lineWidth=this.lineWidth;a.strokeStyle=this.lineColor;a.beginPath();a.moveTo(b-5,d);a.lineTo(b,d);a.stroke();a.closePath()},this);ae(this.xLabels,function(i,h){var e=this.calculateX(h)+aC(this.lineWidth),g=this.calculateX(h-(this.offsetGridLines?0.5:0))+aC(this.lineWidth),f=(this.xLabelRotation>0),d=this.showVerticalLines;if(h===0&&!d){d=true}if(d){a.beginPath()}if(h>0){a.lineWidth=this.gridLineWidth;a.strokeStyle=this.gridLineColor}else{a.lineWidth=this.lineWidth;a.strokeStyle=this.lineColor}if(d){a.moveTo(g,this.endPoint);a.lineTo(g,this.startPoint-3);a.stroke();a.closePath()}a.lineWidth=this.lineWidth;a.strokeStyle=this.lineColor;a.beginPath();a.moveTo(g,this.endPoint);a.lineTo(g,this.endPoint+5);a.stroke();a.closePath();a.save();a.translate(e,(f)?this.endPoint+12:this.endPoint+8);a.rotate(af(this.xLabelRotation)*-1);a.font=this.font;a.textAlign=(f)?"right":"center";a.textBaseline=(f)?"middle":"top";a.fillText(i,0,0);a.restore()},this)}}});al.RadialScale=al.Element.extend({initialize:function(){this.size=Y([this.height,this.width]);this.drawingArea=(this.display)?(this.size/2)-(this.fontSize/2+this.backdropPaddingY):(this.size/2)},calculateCenterOffset:function(b){var a=this.drawingArea/(this.max-this.min);return(b-this.min)*a},update:function(){if(!this.lineArc){this.setScaleSize()}else{this.drawingArea=(this.display)?(this.size/2)-(this.fontSize/2+this.backdropPaddingY):(this.size/2)}this.buildYLabels()},buildYLabels:function(){this.yLabels=[];var b=am(this.stepValue);for(var a=0;a<=this.steps;a++){this.yLabels.push(aK(this.templateString,{value:(this.min+(a*this.stepValue)).toFixed(b)}))}},getCircumference:function(){return((Math.PI*2)/this.valuesCount)},setScaleSize:function(){var e=Y([(this.height/2-this.pointLabelFontSize-5),this.width/2]),g,a,j,b,f=this.width,h,n,o=0,k,c,i,l,p,d,m;this.ctx.font=aN(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily);for(a=0;a<this.valuesCount;a++){g=this.getPointPosition(a,e);j=this.ctx.measureText(aK(this.templateString,{value:this.labels[a]})).width+5;if(a===0||a===this.valuesCount/2){b=j/2;if(g.x+b>f){f=g.x+b;h=a}if(g.x-b<o){o=g.x-b;k=a}}else{if(a<this.valuesCount/2){if(g.x+j>f){f=g.x+j;h=a}}else{if(a>this.valuesCount/2){if(g.x-j<o){o=g.x-j;k=a}}}}}i=o;l=Math.ceil(f-this.width);n=this.getIndexAngle(h);c=this.getIndexAngle(k);p=l/Math.sin(n+Math.PI/2);d=i/Math.sin(c+Math.PI/2);p=(X(p))?p:0;d=(X(d))?d:0;this.drawingArea=e-(d+p)/2;this.setCenterPoint(d,p)},setCenterPoint:function(b,a){var c=this.width-a-this.drawingArea,d=b+this.drawingArea;this.xCenter=(d+c)/2;this.yCenter=(this.height/2)},getIndexAngle:function(b){var a=(Math.PI*2)/this.valuesCount;return b*a-(Math.PI/2)},getPointPosition:function(c,b){var a=this.getIndexAngle(c);return{x:(Math.cos(a)*b)+this.xCenter,y:(Math.sin(a)*b)+this.yCenter}},draw:function(){if(this.display){var f=this.ctx;ae(this.yLabels,function(q,r){if(r>0){var s=r*(this.drawingArea/this.steps),t=this.yCenter-s,o;if(this.lineWidth>0){f.strokeStyle=this.lineColor;f.lineWidth=this.lineWidth;if(this.lineArc){f.beginPath();f.arc(this.xCenter,this.yCenter,s,0,Math.PI*2);f.closePath();f.stroke()}else{f.beginPath();for(var p=0;p<this.valuesCount;p++){o=this.getPointPosition(p,this.calculateCenterOffset(this.min+(r*this.stepValue)));if(p===0){f.moveTo(o.x,o.y)}else{f.lineTo(o.x,o.y)}}f.closePath();f.stroke()}}if(this.showLabels){f.font=aN(this.fontSize,this.fontStyle,this.fontFamily);if(this.showLabelBackdrop){var u=f.measureText(q).width;f.fillStyle=this.backdropColor;f.fillRect(this.xCenter-u/2-this.backdropPaddingX,t-this.fontSize/2-this.backdropPaddingY,u+this.backdropPaddingX*2,this.fontSize+this.backdropPaddingY*2)}f.textAlign="center";f.textBaseline="middle";f.fillStyle=this.fontColor;f.fillText(q,this.xCenter,t)}}},this);if(!this.lineArc){f.lineWidth=this.angleLineWidth;f.strokeStyle=this.angleLineColor;for(var n=this.valuesCount-1;n>=0;n--){var i=null,d=null;if(this.angleLineWidth>0&&(n%this.angleLineInterval===0)){i=this.calculateCenterOffset(this.max);d=this.getPointPosition(n,i);f.beginPath();f.moveTo(this.xCenter,this.yCenter);f.lineTo(d.x,d.y);f.stroke();f.closePath()}if(this.backgroundColors&&this.backgroundColors.length==this.valuesCount){if(i==null){i=this.calculateCenterOffset(this.max)}if(d==null){d=this.getPointPosition(n,i)}var b=this.getPointPosition(n===0?this.valuesCount-1:n-1,i);var g=this.getPointPosition(n===this.valuesCount-1?0:n+1,i);var c={x:(b.x+d.x)/2,y:(b.y+d.y)/2};var a={x:(d.x+g.x)/2,y:(d.y+g.y)/2};f.beginPath();f.moveTo(this.xCenter,this.yCenter);f.lineTo(c.x,c.y);f.lineTo(d.x,d.y);f.lineTo(a.x,a.y);f.fillStyle=this.backgroundColors[n];f.fill();f.closePath()}var k=this.getPointPosition(n,this.calculateCenterOffset(this.max)+5);f.font=aN(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily);f.fillStyle=this.pointLabelFontColor;var e=this.labels.length,m=this.labels.length/2,h=m/2,j=(n<h||n>e-h),l=(n===h||n===e-h);if(n===0){f.textAlign="center"}else{if(n===m){f.textAlign="center"}else{if(n<m){f.textAlign="left"}else{f.textAlign="right"}}}if(l){f.textBaseline="middle"}else{if(j){f.textBaseline="bottom"}else{f.textBaseline="top"}}f.fillText(this.labels[n],k.x,k.y)}}}}});al.animationService={frameDuration:17,animations:[],dropFrames:0,addAnimation:function(a,b){for(var c=0;c<this.animations.length;++c){if(this.animations[c].chartInstance===a){this.animations[c].animationObject=b;return}}this.animations.push({chartInstance:a,animationObject:b});if(this.animations.length==1){ak.requestAnimFrame.call(window,this.digestWrapper)}},cancelAnimation:function(a){var b=ak.findNextWhere(this.animations,function(c){return c.chartInstance===a});if(b){this.animations.splice(b,1)}},digestWrapper:function(){al.animationService.startDigest.call(al.animationService)},startDigest:function(){var d=Date.now();var a=0;if(this.dropFrames>1){a=Math.floor(this.dropFrames);this.dropFrames-=a}for(var c=0;c<this.animations.length;c++){if(this.animations[c].animationObject.currentStep===null){this.animations[c].animationObject.currentStep=0}this.animations[c].animationObject.currentStep+=1+a;if(this.animations[c].animationObject.currentStep>this.animations[c].animationObject.numSteps){this.animations[c].animationObject.currentStep=this.animations[c].animationObject.numSteps}this.animations[c].animationObject.render(this.animations[c].chartInstance,this.animations[c].animationObject);if(this.animations[c].animationObject.currentStep==this.animations[c].animationObject.numSteps){this.animations[c].animationObject.onAnimationComplete.call(this.animations[c].chartInstance);this.animations.splice(c,1);c--}}var f=Date.now();var e=f-d-this.frameDuration;var b=e/this.frameDuration;if(b>1){this.dropFrames+=b}if(this.animations.length>0){ak.requestAnimFrame.call(window,this.digestWrapper)}}};ak.addEvent(window,"resize",(function(){var a;return function(){clearTimeout(a);a=setTimeout(function(){ae(al.instances,function(b){if(b.options.responsive){b.resize(b.render,true)}})},50)}})());if(aI){define("Chart",[],function(){return al})}else{if(typeof module==="object"&&module.exports){module.exports=al}}ar.Chart=al;al.noConflict=function(){ar.Chart=ai;return al}}).call(this);(function(){var h=this,e=h.Chart,g=e.helpers;var f={scaleBeginAtZero:true,scaleShowGridLines:true,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:true,scaleShowVerticalLines:true,barShowStroke:true,barStrokeWidth:2,barValueSpacing:5,barDatasetSpacing:1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=datasets[i].fillColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(datasets[i].label){%><%=datasets[i].label%><%}%></span></li><%}%></ul>'};e.Type.extend({name:"Bar",defaults:f,initialize:function(a){var b=this.options;this.ScaleClass=e.Scale.extend({offsetGridLines:true,calculateBarX:function(p,c,n){var o=this.calculateBaseWidth(),d=this.calculateX(n)-(o/2),m=this.calculateBarWidth(p);return d+(m*c)+(c*b.barDatasetSpacing)+m/2},calculateBaseWidth:function(){return(this.calculateX(1)-this.calculateX(0))-(2*b.barValueSpacing)},calculateBarWidth:function(c){var d=this.calculateBaseWidth()-((c-1)*b.barDatasetSpacing);return(d/c)}});this.datasets=[];if(this.options.showTooltips){g.bindEvents(this,this.options.tooltipEvents,function(d){var c=(d.type!=="mouseout")?this.getBarsAtEvent(d):[];this.eachBars(function(j){j.restore(["fillColor","strokeColor"])});g.each(c,function(j){if(j){j.fillColor=j.highlightFill;j.strokeColor=j.highlightStroke}});this.showTooltip(c)})}this.BarClass=e.Rectangle.extend({strokeWidth:this.options.barStrokeWidth,showStroke:this.options.barShowStroke,ctx:this.chart.ctx});g.each(a.datasets,function(d,c){var j={label:d.label||null,fillColor:d.fillColor,strokeColor:d.strokeColor,bars:[]};this.datasets.push(j);g.each(d.data,function(l,i){j.bars.push(new this.BarClass({value:l,label:a.labels[i],datasetLabel:d.label,strokeColor:(typeof d.strokeColor=="object")?d.strokeColor[i]:d.strokeColor,fillColor:(typeof d.fillColor=="object")?d.fillColor[i]:d.fillColor,highlightFill:(d.highlightFill)?(typeof d.highlightFill=="object")?d.highlightFill[i]:d.highlightFill:(typeof d.fillColor=="object")?d.fillColor[i]:d.fillColor,highlightStroke:(d.highlightStroke)?(typeof d.highlightStroke=="object")?d.highlightStroke[i]:d.highlightStroke:(typeof d.strokeColor=="object")?d.strokeColor[i]:d.strokeColor}))},this)},this);this.buildScale(a.labels);this.BarClass.prototype.base=this.scale.endPoint;this.eachBars(function(d,j,c){g.extend(d,{width:this.scale.calculateBarWidth(this.datasets.length),x:this.scale.calculateBarX(this.datasets.length,c,j),y:this.scale.endPoint});d.save()},this);this.render()},update:function(){this.scale.update();g.each(this.activeElements,function(a){a.restore(["fillColor","strokeColor"])});this.eachBars(function(a){a.save()});this.render()},eachBars:function(a){g.each(this.datasets,function(c,b){g.each(c.bars,a,this,b)},this)},getBarsAtEvent:function(b){var l=[],c=g.getRelativePosition(b),m=function(i){l.push(i.bars[d])},d;for(var a=0;a<this.datasets.length;a++){for(d=0;d<this.datasets[a].bars.length;d++){if(this.datasets[a].bars[d].inRange(c.x,c.y)){g.each(this.datasets,m);return l}}}return l},buildScale:function(a){var c=this;var b=function(){var j=[];c.eachBars(function(i){j.push(i.value)});return j};var d={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:a.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(k){var l=g.calculateScaleRange(b(),k,this.fontSize,this.beginAtZero,this.integersOnly);g.extend(this,l)},xLabels:a,font:g.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:(this.options.scaleShowGridLines)?this.options.scaleGridLineWidth:0,gridLineColor:(this.options.scaleShowGridLines)?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:(this.options.showScale)?0:(this.options.barShowStroke)?this.options.barStrokeWidth:0,showLabels:this.options.scaleShowLabels,display:this.options.showScale};if(this.options.scaleOverride){g.extend(d,{calculateYRange:g.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+(this.options.scaleSteps*this.options.scaleStepWidth)})}this.scale=new this.ScaleClass(d)},addData:function(a,b){g.each(a,function(d,c){this.datasets[c].bars.push(new this.BarClass({value:d,label:b,datasetLabel:this.datasets[c].label,x:this.scale.calculateBarX(this.datasets.length,c,this.scale.valuesCount+1),y:this.scale.endPoint,width:this.scale.calculateBarWidth(this.datasets.length),base:this.scale.endPoint,strokeColor:this.datasets[c].strokeColor,fillColor:this.datasets[c].fillColor}))},this);this.scale.addXLabel(b);this.update()},removeData:function(){this.scale.removeXLabel();g.each(this.datasets,function(a){a.bars.shift()},this);this.update()},reflow:function(){g.extend(this.BarClass.prototype,{y:this.scale.endPoint,base:this.scale.endPoint});var a=g.extend({height:this.chart.height,width:this.chart.width});this.scale.update(a)},draw:function(a){var b=a||1;this.clear();var c=this.chart.ctx;this.scale.draw(b);g.each(this.datasets,function(j,d){g.each(j.bars,function(i,l){if(i.hasValue()){i.base=this.scale.endPoint;i.transition({x:this.scale.calculateBarX(this.datasets.length,d,l),y:this.scale.calculateY(i.value),width:this.scale.calculateBarWidth(this.datasets.length)},b).draw()}},this)},this)}})}).call(this);(function(){var h=this,e=h.Chart,g=e.helpers;var f={segmentShowStroke:true,segmentStrokeColor:"#fff",segmentStrokeWidth:2,percentageInnerCutout:50,animationSteps:100,animationEasing:"easeOutBounce",animateRotate:true,animateScale:false,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=segments[i].fillColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(segments[i].label){%><%=segments[i].label%><%}%></span></li><%}%></ul>'};e.Type.extend({name:"Doughnut",defaults:f,initialize:function(a){this.segments=[];this.outerRadius=(g.min([this.chart.width,this.chart.height])-this.options.segmentStrokeWidth/2)/2;this.SegmentArc=e.Arc.extend({ctx:this.chart.ctx,x:this.chart.width/2,y:this.chart.height/2});if(this.options.showTooltips){g.bindEvents(this,this.options.tooltipEvents,function(c){var b=(c.type!=="mouseout")?this.getSegmentsAtEvent(c):[];g.each(this.segments,function(d){d.restore(["fillColor"])});g.each(b,function(d){d.fillColor=d.highlightColor});this.showTooltip(b)})}this.calculateTotal(a);g.each(a,function(b,c){if(!b.color){b.color="hsl("+(360*c/a.length)+", 100%, 50%)"}this.addData(b,c,true)},this);this.render()},getSegmentsAtEvent:function(a){var b=[];var c=g.getRelativePosition(a);g.each(this.segments,function(d){if(d.inRange(c.x,c.y)){b.push(d)}},this);return b},addData:function(a,b,d){var c=b!==undefined?b:this.segments.length;if(typeof(a.color)==="undefined"){a.color=e.defaults.global.segmentColorDefault[c%e.defaults.global.segmentColorDefault.length];a.highlight=e.defaults.global.segmentHighlightColorDefaults[c%e.defaults.global.segmentHighlightColorDefaults.length]}this.segments.splice(c,0,new this.SegmentArc({value:a.value,outerRadius:(this.options.animateScale)?0:this.outerRadius,innerRadius:(this.options.animateScale)?0:(this.outerRadius/100)*this.options.percentageInnerCutout,fillColor:a.color,highlightColor:a.highlight||a.color,showStroke:this.options.segmentShowStroke,strokeWidth:this.options.segmentStrokeWidth,strokeColor:this.options.segmentStrokeColor,startAngle:Math.PI*1.5,circumference:(this.options.animateRotate)?0:this.calculateCircumference(a.value),label:a.label}));if(!d){this.reflow();this.update()}},calculateCircumference:function(a){if(this.total>0){return(Math.PI*2)*(a/this.total)}else{return 0}},calculateTotal:function(a){this.total=0;g.each(a,function(b){this.total+=Math.abs(b.value)},this)},update:function(){this.calculateTotal(this.segments);g.each(this.activeElements,function(a){a.restore(["fillColor"])});g.each(this.segments,function(a){a.save()});this.render()},removeData:function(a){var b=(g.isNumber(a))?a:this.segments.length-1;this.segments.splice(b,1);this.reflow();this.update()},reflow:function(){g.extend(this.SegmentArc.prototype,{x:this.chart.width/2,y:this.chart.height/2});this.outerRadius=(g.min([this.chart.width,this.chart.height])-this.options.segmentStrokeWidth/2)/2;g.each(this.segments,function(a){a.update({outerRadius:this.outerRadius,innerRadius:(this.outerRadius/100)*this.options.percentageInnerCutout})},this)},draw:function(b){var a=(b)?b:1;this.clear();g.each(this.segments,function(c,d){c.transition({circumference:this.calculateCircumference(c.value),outerRadius:this.outerRadius,innerRadius:(this.outerRadius/100)*this.options.percentageInnerCutout},a);c.endAngle=c.startAngle+c.circumference;c.draw();if(d===0){c.startAngle=Math.PI*1.5}if(d<this.segments.length-1){this.segments[d+1].startAngle=c.endAngle}},this)}});e.types.Doughnut.extend({name:"Pie",defaults:g.merge(f,{percentageInnerCutout:0})})}).call(this);(function(){var h=this,e=h.Chart,g=e.helpers;var f={scaleShowGridLines:true,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:true,scaleShowVerticalLines:true,bezierCurve:true,bezierCurveTension:0.4,pointDot:true,pointDotRadius:4,pointDotStrokeWidth:1,pointHitDetectionRadius:20,datasetStroke:true,datasetStrokeWidth:2,datasetFill:true,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=datasets[i].strokeColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(datasets[i].label){%><%=datasets[i].label%><%}%></span></li><%}%></ul>',offsetGridLines:false};e.Type.extend({name:"Line",defaults:f,initialize:function(a){this.PointClass=e.Point.extend({offsetGridLines:this.options.offsetGridLines,strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx,inRange:function(b){return(Math.pow(b-this.x,2)<Math.pow(this.radius+this.hitDetectionRadius,2))}});this.datasets=[];if(this.options.showTooltips){g.bindEvents(this,this.options.tooltipEvents,function(c){var b=(c.type!=="mouseout")?this.getPointsAtEvent(c):[];this.eachPoints(function(d){d.restore(["fillColor","strokeColor"])});g.each(b,function(d){d.fillColor=d.highlightFill;d.strokeColor=d.highlightStroke});this.showTooltip(b)})}g.each(a.datasets,function(b){var c={label:b.label||null,fillColor:b.fillColor,strokeColor:b.strokeColor,pointColor:b.pointColor,pointStrokeColor:b.pointStrokeColor,points:[]};this.datasets.push(c);g.each(b.data,function(j,d){c.points.push(new this.PointClass({value:j,label:a.labels[d],datasetLabel:b.label,strokeColor:b.pointStrokeColor,fillColor:b.pointColor,highlightFill:b.pointHighlightFill||b.pointColor,highlightStroke:b.pointHighlightStroke||b.pointStrokeColor}))},this);this.buildScale(a.labels);this.eachPoints(function(j,d){g.extend(j,{x:this.scale.calculateX(d),y:this.scale.endPoint});j.save()},this)},this);this.render()},update:function(){this.scale.update();g.each(this.activeElements,function(a){a.restore(["fillColor","strokeColor"])});this.eachPoints(function(a){a.save()});this.render()},eachPoints:function(a){g.each(this.datasets,function(b){g.each(b.points,a,this)},this)},getPointsAtEvent:function(b){var a=[],c=g.getRelativePosition(b);g.each(this.datasets,function(d){g.each(d.points,function(j){if(j.inRange(c.x,c.y)){a.push(j)}})},this);return a},buildScale:function(a){var c=this;var b=function(){var j=[];c.eachPoints(function(i){j.push(i.value)});return j};var d={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,offsetGridLines:this.options.offsetGridLines,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:a.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(k){var l=g.calculateScaleRange(b(),k,this.fontSize,this.beginAtZero,this.integersOnly);g.extend(this,l)},xLabels:a,font:g.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:(this.options.scaleShowGridLines)?this.options.scaleGridLineWidth:0,gridLineColor:(this.options.scaleShowGridLines)?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:(this.options.showScale)?0:this.options.pointDotRadius+this.options.pointDotStrokeWidth,showLabels:this.options.scaleShowLabels,display:this.options.showScale};if(this.options.scaleOverride){g.extend(d,{calculateYRange:g.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+(this.options.scaleSteps*this.options.scaleStepWidth)})}this.scale=new e.Scale(d)},addData:function(a,b){g.each(a,function(d,c){this.datasets[c].points.push(new this.PointClass({value:d,label:b,datasetLabel:this.datasets[c].label,x:this.scale.calculateX(this.scale.valuesCount+1),y:this.scale.endPoint,strokeColor:this.datasets[c].pointStrokeColor,fillColor:this.datasets[c].pointColor}))},this);this.scale.addXLabel(b);this.update()},removeData:function(){this.scale.removeXLabel();g.each(this.datasets,function(a){a.points.shift()},this);this.update()},reflow:function(){var a=g.extend({height:this.chart.height,width:this.chart.width});this.scale.update(a)},draw:function(a){var k=a||1;this.clear();var l=this.chart.ctx;var d=function(i){return i.value!==null},b=function(n,i,j){return g.findNextWhere(i,d,j)||n},c=function(n,i,j){return g.findPreviousWhere(i,d,j)||n};if(!this.scale){return}this.scale.draw(k);g.each(this.datasets,function(i){var j=g.where(i.points,d);g.each(i.points,function(o,p){if(o.hasValue()){o.transition({y:this.scale.calculateY(o.value),x:this.scale.calculateX(p)},k)}},this);if(this.options.bezierCurve){g.each(j,function(p,r){var q=(r>0&&r<j.length-1)?this.options.bezierCurveTension:0;p.controlPoints=g.splineCurve(c(p,j,r),p,b(p,j,r),q);if(p.controlPoints.outer.y>this.scale.endPoint){p.controlPoints.outer.y=this.scale.endPoint}else{if(p.controlPoints.outer.y<this.scale.startPoint){p.controlPoints.outer.y=this.scale.startPoint}}if(p.controlPoints.inner.y>this.scale.endPoint){p.controlPoints.inner.y=this.scale.endPoint}else{if(p.controlPoints.inner.y<this.scale.startPoint){p.controlPoints.inner.y=this.scale.startPoint}}},this)}l.lineWidth=this.options.datasetStrokeWidth;l.strokeStyle=i.strokeColor;l.beginPath();g.each(j,function(p,r){if(r===0){l.moveTo(p.x,p.y)}else{if(this.options.bezierCurve){var q=c(p,j,r);l.bezierCurveTo(q.controlPoints.outer.x,q.controlPoints.outer.y,p.controlPoints.inner.x,p.controlPoints.inner.y,p.x,p.y)}else{l.lineTo(p.x,p.y)}}},this);if(this.options.datasetStroke){l.stroke()}if(this.options.datasetFill&&j.length>0){l.lineTo(j[j.length-1].x,this.scale.endPoint);l.lineTo(j[0].x,this.scale.endPoint);l.fillStyle=i.fillColor;l.closePath();l.fill()}g.each(j,function(n){n.draw()})},this)}})}).call(this);(function(){var h=this,e=h.Chart,g=e.helpers;var f={scaleShowLabelBackdrop:true,scaleBackdropColor:"rgba(255,255,255,0.75)",scaleBeginAtZero:true,scaleBackdropPaddingY:2,scaleBackdropPaddingX:2,scaleShowLine:true,segmentShowStroke:true,segmentStrokeColor:"#fff",segmentStrokeWidth:2,animationSteps:100,animationEasing:"easeOutBounce",animateRotate:true,animateScale:false,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=segments[i].fillColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(segments[i].label){%><%=segments[i].label%><%}%></span></li><%}%></ul>'};e.Type.extend({name:"PolarArea",defaults:f,initialize:function(a){this.segments=[];this.SegmentArc=e.Arc.extend({showStroke:this.options.segmentShowStroke,strokeWidth:this.options.segmentStrokeWidth,strokeColor:this.options.segmentStrokeColor,ctx:this.chart.ctx,innerRadius:0,x:this.chart.width/2,y:this.chart.height/2});this.scale=new e.RadialScale({display:this.options.showScale,fontStyle:this.options.scaleFontStyle,fontSize:this.options.scaleFontSize,fontFamily:this.options.scaleFontFamily,fontColor:this.options.scaleFontColor,showLabels:this.options.scaleShowLabels,showLabelBackdrop:this.options.scaleShowLabelBackdrop,backdropColor:this.options.scaleBackdropColor,backdropPaddingY:this.options.scaleBackdropPaddingY,backdropPaddingX:this.options.scaleBackdropPaddingX,lineWidth:(this.options.scaleShowLine)?this.options.scaleLineWidth:0,lineColor:this.options.scaleLineColor,lineArc:true,width:this.chart.width,height:this.chart.height,xCenter:this.chart.width/2,yCenter:this.chart.height/2,ctx:this.chart.ctx,templateString:this.options.scaleLabel,valuesCount:a.length});this.updateScaleRange(a);this.scale.update();g.each(a,function(b,c){this.addData(b,c,true)},this);if(this.options.showTooltips){g.bindEvents(this,this.options.tooltipEvents,function(c){var b=(c.type!=="mouseout")?this.getSegmentsAtEvent(c):[];g.each(this.segments,function(d){d.restore(["fillColor"])});g.each(b,function(d){d.fillColor=d.highlightColor});this.showTooltip(b)})}this.render()},getSegmentsAtEvent:function(a){var b=[];var c=g.getRelativePosition(a);g.each(this.segments,function(d){if(d.inRange(c.x,c.y)){b.push(d)}},this);return b},addData:function(a,b,d){var c=b||this.segments.length;this.segments.splice(c,0,new this.SegmentArc({fillColor:a.color,highlightColor:a.highlight||a.color,label:a.label,value:a.value,outerRadius:(this.options.animateScale)?0:this.scale.calculateCenterOffset(a.value),circumference:(this.options.animateRotate)?0:this.scale.getCircumference(),startAngle:Math.PI*1.5}));if(!d){this.reflow();this.update()}},removeData:function(a){var b=(g.isNumber(a))?a:this.segments.length-1;this.segments.splice(b,1);this.reflow();this.update()},calculateTotal:function(a){this.total=0;g.each(a,function(b){this.total+=b.value},this);this.scale.valuesCount=this.segments.length},updateScaleRange:function(b){var c=[];g.each(b,function(d){c.push(d.value)});var a=(this.options.scaleOverride)?{steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+(this.options.scaleSteps*this.options.scaleStepWidth)}:g.calculateScaleRange(c,g.min([this.chart.width,this.chart.height])/2,this.options.scaleFontSize,this.options.scaleBeginAtZero,this.options.scaleIntegersOnly);g.extend(this.scale,a,{size:g.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2})},update:function(){this.calculateTotal(this.segments);g.each(this.segments,function(a){a.save()});this.reflow();this.render()},reflow:function(){g.extend(this.SegmentArc.prototype,{x:this.chart.width/2,y:this.chart.height/2});this.updateScaleRange(this.segments);this.scale.update();g.extend(this.scale,{xCenter:this.chart.width/2,yCenter:this.chart.height/2});g.each(this.segments,function(a){a.update({outerRadius:this.scale.calculateCenterOffset(a.value)})},this)},draw:function(a){var b=a||1;this.clear();g.each(this.segments,function(c,d){c.transition({circumference:this.scale.getCircumference(),outerRadius:this.scale.calculateCenterOffset(c.value)},b);c.endAngle=c.startAngle+c.circumference;if(d===0){c.startAngle=Math.PI*1.5}if(d<this.segments.length-1){this.segments[d+1].startAngle=c.endAngle}c.draw()},this);this.scale.draw()}})}).call(this);(function(){var d=this,e=d.Chart,f=e.helpers;e.Type.extend({name:"Radar",defaults:{scaleShowLine:true,angleShowLineOut:true,scaleShowLabels:false,scaleBeginAtZero:true,angleLineColor:"rgba(0,0,0,.1)",angleLineWidth:1,angleLineInterval:1,pointLabelFontFamily:"'Arial'",pointLabelFontStyle:"normal",pointLabelFontSize:10,pointLabelFontColor:"#666",pointDot:true,pointDotRadius:3,pointDotStrokeWidth:1,pointHitDetectionRadius:20,datasetStroke:true,datasetStrokeWidth:2,datasetFill:true,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=datasets[i].strokeColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(datasets[i].label){%><%=datasets[i].label%><%}%></span></li><%}%></ul>'},initialize:function(a){this.PointClass=e.Point.extend({strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx});this.datasets=[];this.buildScale(a);if(this.options.showTooltips){f.bindEvents(this,this.options.tooltipEvents,function(c){var b=(c.type!=="mouseout")?this.getPointsAtEvent(c):[];this.eachPoints(function(h){h.restore(["fillColor","strokeColor"])});f.each(b,function(h){h.fillColor=h.highlightFill;h.strokeColor=h.highlightStroke});this.showTooltip(b)})}f.each(a.datasets,function(b){var c={label:b.label||null,fillColor:b.fillColor,strokeColor:b.strokeColor,pointColor:b.pointColor,pointStrokeColor:b.pointStrokeColor,points:[]};this.datasets.push(c);f.each(b.data,function(l,k){var j;if(!this.scale.animation){j=this.scale.getPointPosition(k,this.scale.calculateCenterOffset(l))}c.points.push(new this.PointClass({value:l,label:a.labels[k],datasetLabel:b.label,x:(this.options.animation)?this.scale.xCenter:j.x,y:(this.options.animation)?this.scale.yCenter:j.y,strokeColor:b.pointStrokeColor,fillColor:b.pointColor,highlightFill:b.pointHighlightFill||b.pointColor,highlightStroke:b.pointHighlightStroke||b.pointStrokeColor}))},this)},this);this.render()},eachPoints:function(a){f.each(this.datasets,function(b){f.each(b.points,a,this)},this)},getPointsAtEvent:function(l){var a=f.getRelativePosition(l),j=f.getAngleFromPoint({x:this.scale.xCenter,y:this.scale.yCenter},a);var k=(Math.PI*2)/this.scale.valuesCount,c=Math.round((j.angle-Math.PI*1.5)/k),b=[];if(c>=this.scale.valuesCount||c<0){c=0}if(j.distance<=this.scale.drawingArea){f.each(this.datasets,function(g){b.push(g.points[c])})}return b},buildScale:function(a){this.scale=new e.RadialScale({display:this.options.showScale,fontStyle:this.options.scaleFontStyle,fontSize:this.options.scaleFontSize,fontFamily:this.options.scaleFontFamily,fontColor:this.options.scaleFontColor,showLabels:this.options.scaleShowLabels,showLabelBackdrop:this.options.scaleShowLabelBackdrop,backdropColor:this.options.scaleBackdropColor,backgroundColors:this.options.scaleBackgroundColors,backdropPaddingY:this.options.scaleBackdropPaddingY,backdropPaddingX:this.options.scaleBackdropPaddingX,lineWidth:(this.options.scaleShowLine)?this.options.scaleLineWidth:0,lineColor:this.options.scaleLineColor,angleLineColor:this.options.angleLineColor,angleLineWidth:(this.options.angleShowLineOut)?this.options.angleLineWidth:0,angleLineInterval:(this.options.angleLineInterval)?this.options.angleLineInterval:1,pointLabelFontColor:this.options.pointLabelFontColor,pointLabelFontSize:this.options.pointLabelFontSize,pointLabelFontFamily:this.options.pointLabelFontFamily,pointLabelFontStyle:this.options.pointLabelFontStyle,height:this.chart.height,width:this.chart.width,xCenter:this.chart.width/2,yCenter:this.chart.height/2,ctx:this.chart.ctx,templateString:this.options.scaleLabel,labels:a.labels,valuesCount:a.datasets[0].data.length});this.scale.setScaleSize();this.updateScaleRange(a.datasets);this.scale.buildYLabels()},updateScaleRange:function(b){var c=(function(){var h=[];f.each(b,function(g){if(g.data){h=h.concat(g.data)}else{f.each(g.points,function(j){h.push(j.value)})}});return h})();var a=(this.options.scaleOverride)?{steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+(this.options.scaleSteps*this.options.scaleStepWidth)}:f.calculateScaleRange(c,f.min([this.chart.width,this.chart.height])/2,this.options.scaleFontSize,this.options.scaleBeginAtZero,this.options.scaleIntegersOnly);f.extend(this.scale,a)},addData:function(a,b){this.scale.valuesCount++;f.each(a,function(j,c){var i=this.scale.getPointPosition(this.scale.valuesCount,this.scale.calculateCenterOffset(j));this.datasets[c].points.push(new this.PointClass({value:j,label:b,datasetLabel:this.datasets[c].label,x:i.x,y:i.y,strokeColor:this.datasets[c].pointStrokeColor,fillColor:this.datasets[c].pointColor}))},this);this.scale.labels.push(b);this.reflow();this.update()},removeData:function(){this.scale.valuesCount--;this.scale.labels.shift();f.each(this.datasets,function(a){a.points.shift()},this);this.reflow();this.update()},update:function(){this.eachPoints(function(a){a.save()});this.reflow();this.render()},reflow:function(){f.extend(this.scale,{width:this.chart.width,height:this.chart.height,size:f.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2});this.updateScaleRange(this.datasets);this.scale.setScaleSize();this.scale.buildYLabels()},draw:function(a){var b=a||1,c=this.chart.ctx;this.clear();this.scale.draw();f.each(this.datasets,function(h){f.each(h.points,function(j,g){if(j.hasValue()){j.transition(this.scale.getPointPosition(g,this.scale.calculateCenterOffset(j.value)),b)}},this);c.lineWidth=this.options.datasetStrokeWidth;c.strokeStyle=h.strokeColor;c.beginPath();f.each(h.points,function(j,g){if(g===0){c.moveTo(j.x,j.y)}else{c.lineTo(j.x,j.y)}},this);c.closePath();c.stroke();c.fillStyle=h.fillColor;if(this.options.datasetFill){c.fill()}f.each(h.points,function(g){if(g.hasValue()){g.draw()}})},this)}})}).call(this);