/*!
 * Chart.js
 * http://chartjs.org/
 * Version: 1.1.1
 *
 * Copyright 2015 Nick Downie
 * Released under the MIT license
 * https://github.com/nnnick/Chart.js/blob/master/LICENSE.md
 */
(function(){var A=this,J=A.Chart;var G=function(Y){var aa=this;this.canvas=Y.canvas;this.ctx=Y;var X=function(ab,ac){if(ab["offset"+ac]){return ab["offset"+ac]}else{return document.defaultView.getComputedStyle(ab).getPropertyValue(ac)}};var Z=this.width=X(Y.canvas,"Width")||Y.canvas.width;var W=this.height=X(Y.canvas,"Height")||Y.canvas.height;this.aspectRatio=this.width/this.height;H.retinaScale(this);return this};G.defaults={global:{animation:true,animationSteps:60,animationEasing:"easeOutQuart",showScale:true,scaleOverride:false,scaleSteps:null,scaleStepWidth:null,scaleStartValue:null,scaleLineColor:"rgba(0,0,0,.1)",scaleLineWidth:1,scaleShowLabels:true,scaleLabel:"<%=value%>",scaleIntegersOnly:true,scaleBeginAtZero:false,scaleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",scaleFontSize:12,scaleFontStyle:"normal",scaleFontColor:"#666",responsive:false,maintainAspectRatio:true,showTooltips:true,customTooltips:false,tooltipEvents:["mousemove","touchstart","touchmove","mouseout"],tooltipFillColor:"rgba(0,0,0,0.8)",tooltipFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipFontSize:14,tooltipFontStyle:"normal",tooltipFontColor:"#fff",tooltipTitleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipTitleFontSize:14,tooltipTitleFontStyle:"bold",tooltipTitleFontColor:"#fff",tooltipTitleTemplate:"<%= label%>",tooltipYPadding:6,tooltipXPadding:6,tooltipCaretSize:8,tooltipCornerRadius:6,tooltipXOffset:10,tooltipTemplate:"<%if (label){%><%=label%>: <%}%><%= value %>",multiTooltipTemplate:"<%= datasetLabel %>: <%= value %>",multiTooltipKeyBackground:"#fff",segmentColorDefault:["#A6CEE3","#1F78B4","#B2DF8A","#33A02C","#FB9A99","#E31A1C","#FDBF6F","#FF7F00","#CAB2D6","#6A3D9A","#B4B482","#B15928"],segmentHighlightColorDefaults:["#CEF6FF","#47A0DC","#DAFFB2","#5BC854","#FFC2C1","#FF4244","#FFE797","#FFA728","#F2DAFE","#9265C2","#DCDCAA","#D98150"],onAnimationProgress:function(){},onAnimationComplete:function(){}}};G.types={};var H=G.helpers={};var N=H.each=function(Z,ab,X){var W=Array.prototype.slice.call(arguments,3);if(Z){if(Z.length===+Z.length){var Y;for(Y=0;Y<Z.length;Y++){ab.apply(X,[Z[Y],Y].concat(W))}}else{for(var aa in Z){ab.apply(X,[Z[aa],aa].concat(W))}}}},y=H.clone=function(X){var W={};N(X,function(Z,Y){if(X.hasOwnProperty(Y)){W[Y]=Z}});return W},s=H.extend=function(W){N(Array.prototype.slice.call(arguments,1),function(X){N(X,function(Z,Y){if(X.hasOwnProperty(Y)){W[Y]=Z}})});return W},L=H.merge=function(Y,X){var W=Array.prototype.slice.call(arguments,0);W.unshift({});return s.apply(null,W)},v=H.indexOf=function(W,Y){if(Array.prototype.indexOf){return W.indexOf(Y)}else{for(var X=0;X<W.length;X++){if(W[X]===Y){return X}}return -1}},m=H.where=function(Y,X){var W=[];H.each(Y,function(Z){if(X(Z)){W.push(Z)}});return W},e=H.findNextWhere=function(W,aa,Z){if(!Z){Z=-1}for(var Y=Z+1;Y<W.length;Y++){var X=W[Y];if(aa(X)){return X}}},D=H.findPreviousWhere=function(W,aa,Z){if(!Z){Z=W.length}for(var Y=Z-1;Y>=0;Y--){var X=W[Y];if(aa(X)){return X}}},h=H.inherits=function(X){var W=this;var Y=(X&&X.hasOwnProperty("constructor"))?X.constructor:function(){return W.apply(this,arguments)};var Z=function(){this.constructor=Y};Z.prototype=W.prototype;Y.prototype=new Z();Y.extend=h;if(X){s(Y.prototype,X)}Y.__super__=W.prototype;return Y},Q=H.noop=function(){},j=H.uid=(function(){var W=0;return function(){return"chart-"+W++}})(),r=H.warn=function(W){if(window.console&&typeof window.console.warn==="function"){console.warn(W)}},k=H.amd=(typeof define==="function"&&define.amd),U=H.isNumber=function(W){return !isNaN(parseFloat(W))&&isFinite(W)},z=H.max=function(W){return Math.max.apply(Math,W)},T=H.min=function(W){return Math.min.apply(Math,W)},I=H.cap=function(W,Y,X){if(U(Y)){if(W>Y){return Y}}else{if(U(X)){if(W<X){return X}}}return W},F=H.getDecimalPlaces=function(W){if(W%1!==0&&U(W)){var X=W.toString();if(X.indexOf("e-")<0){return X.split(".")[1].length}else{if(X.indexOf(".")<0){return parseInt(X.split("e-")[1])}else{var Y=X.split(".")[1].split("e-");return Y[0].length+parseInt(Y[1])}}}else{return 0}},M=H.radians=function(W){return W*(Math.PI/180)},a=H.getAngleFromPoint=function(Z,X){var aa=X.x-Z.x,W=X.y-Z.y,Y=Math.sqrt(aa*aa+W*W);var ab=Math.PI*2+Math.atan2(W,aa);if(aa<0&&W<0){ab+=Math.PI*2}return{angle:ab,distance:Y}},q=H.aliasPixel=function(W){return(W%2===0)?0:0.5},b=H.splineCurve=function(X,aa,ac,W){var ab=Math.sqrt(Math.pow(aa.x-X.x,2)+Math.pow(aa.y-X.y,2)),ad=Math.sqrt(Math.pow(ac.x-aa.x,2)+Math.pow(ac.y-aa.y,2)),Z=W*ab/(ab+ad),Y=W*ad/(ab+ad);return{inner:{x:aa.x-Z*(ac.x-X.x),y:aa.y-Z*(ac.y-X.y)},outer:{x:aa.x+Y*(ac.x-X.x),y:aa.y+Y*(ac.y-X.y)}}},S=H.calculateOrderOfMagnitude=function(W){return Math.floor(Math.log(W)/Math.LN10)},n=H.calculateScaleRange=function(aa,X,ah,ai,ab){var aj=2,am=Math.floor(X/(ah*1.5)),Z=(aj>=am);var W=[];N(aa,function(ao){ao==null||W.push(ao)});var ag=T(W),ak=z(W);if(ak===ag){ak+=0.5;if(ag>=0.5&&!ai){ag-=0.5}else{ak+=0.5}}var ae=Math.abs(ak-ag),al=S(ae),af=Math.ceil(ak/(1*Math.pow(10,al)))*Math.pow(10,al),ad=(ai)?0:Math.floor(ag/(1*Math.pow(10,al)))*Math.pow(10,al),Y=af-ad,ac=Math.pow(10,al),an=Math.round(Y/ac);while((an>am||(an*2)<am)&&!Z){if(an>am){ac*=2;an=Math.round(Y/ac);if(an%1!==0){Z=true}}else{if(ab&&al>=0){if(ac/2%1===0){ac/=2;an=Math.round(Y/ac)}else{break}}else{ac/=2;an=Math.round(Y/ac)}}}if(Z){an=aj;ac=Y/an}return{steps:an,stepValue:ac,min:ad,max:ad+(an*ac)}},i=H.template=function(Z,Y){if(Z instanceof Function){return Z(Y)}var X={};function W(ac,ab){var aa=!/\W/.test(ac)?X[ac]=X[ac]:new Function("obj","var p=[],print=function(){p.push.apply(p,arguments);};with(obj){p.push('"+ac.replace(/[\r\t\n]/g," ").split("<%").join("\t").replace(/((^|%>)[^\t]*)'/g,"$1\r").replace(/\t=(.*?)%>/g,"',$1,'").split("\t").join("');").split("%>").join("p.push('").split("\r").join("\\'")+"');}return p.join('');");return ab?aa(ab):aa}return W(Z,Y)},u=H.generateLabels=function(Z,X,aa,W){var Y=new Array(X);if(Z){N(Y,function(ac,ab){Y[ab]=i(Z,{value:(aa+(W*(ab+1)))})})}return Y},O=H.easingEffects={linear:function(W){return W},easeInQuad:function(W){return W*W},easeOutQuad:function(W){return -1*W*(W-2)},easeInOutQuad:function(W){if((W/=1/2)<1){return 1/2*W*W}return -1/2*((--W)*(W-2)-1)},easeInCubic:function(W){return W*W*W},easeOutCubic:function(W){return 1*((W=W/1-1)*W*W+1)},easeInOutCubic:function(W){if((W/=1/2)<1){return 1/2*W*W*W}return 1/2*((W-=2)*W*W+2)},easeInQuart:function(W){return W*W*W*W},easeOutQuart:function(W){return -1*((W=W/1-1)*W*W*W-1)},easeInOutQuart:function(W){if((W/=1/2)<1){return 1/2*W*W*W*W}return -1/2*((W-=2)*W*W*W-2)},easeInQuint:function(W){return 1*(W/=1)*W*W*W*W},easeOutQuint:function(W){return 1*((W=W/1-1)*W*W*W*W+1)},easeInOutQuint:function(W){if((W/=1/2)<1){return 1/2*W*W*W*W*W}return 1/2*((W-=2)*W*W*W*W+2)},easeInSine:function(W){return -1*Math.cos(W/1*(Math.PI/2))+1},easeOutSine:function(W){return 1*Math.sin(W/1*(Math.PI/2))},easeInOutSine:function(W){return -1/2*(Math.cos(Math.PI*W/1)-1)},easeInExpo:function(W){return(W===0)?1:1*Math.pow(2,10*(W/1-1))},easeOutExpo:function(W){return(W===1)?1:1*(-Math.pow(2,-10*W/1)+1)},easeInOutExpo:function(W){if(W===0){return 0}if(W===1){return 1}if((W/=1/2)<1){return 1/2*Math.pow(2,10*(W-1))}return 1/2*(-Math.pow(2,-10*--W)+2)},easeInCirc:function(W){if(W>=1){return W}return -1*(Math.sqrt(1-(W/=1)*W)-1)},easeOutCirc:function(W){return 1*Math.sqrt(1-(W=W/1-1)*W)},easeInOutCirc:function(W){if((W/=1/2)<1){return -1/2*(Math.sqrt(1-W*W)-1)}return 1/2*(Math.sqrt(1-(W-=2)*W)+1)},easeInElastic:function(X){var Y=1.70158;var Z=0;var W=1;if(X===0){return 0}if((X/=1)==1){return 1}if(!Z){Z=1*0.3}if(W<Math.abs(1)){W=1;Y=Z/4}else{Y=Z/(2*Math.PI)*Math.asin(1/W)}return -(W*Math.pow(2,10*(X-=1))*Math.sin((X*1-Y)*(2*Math.PI)/Z))},easeOutElastic:function(X){var Y=1.70158;var Z=0;var W=1;if(X===0){return 0}if((X/=1)==1){return 1}if(!Z){Z=1*0.3}if(W<Math.abs(1)){W=1;Y=Z/4}else{Y=Z/(2*Math.PI)*Math.asin(1/W)}return W*Math.pow(2,-10*X)*Math.sin((X*1-Y)*(2*Math.PI)/Z)+1},easeInOutElastic:function(X){var Y=1.70158;var Z=0;var W=1;if(X===0){return 0}if((X/=1/2)==2){return 1}if(!Z){Z=1*(0.3*1.5)}if(W<Math.abs(1)){W=1;Y=Z/4}else{Y=Z/(2*Math.PI)*Math.asin(1/W)}if(X<1){return -0.5*(W*Math.pow(2,10*(X-=1))*Math.sin((X*1-Y)*(2*Math.PI)/Z))}return W*Math.pow(2,-10*(X-=1))*Math.sin((X*1-Y)*(2*Math.PI)/Z)*0.5+1},easeInBack:function(W){var X=1.70158;return 1*(W/=1)*W*((X+1)*W-X)},easeOutBack:function(W){var X=1.70158;return 1*((W=W/1-1)*W*((X+1)*W+X)+1)},easeInOutBack:function(W){var X=1.70158;if((W/=1/2)<1){return 1/2*(W*W*(((X*=(1.525))+1)*W-X))}return 1/2*((W-=2)*W*(((X*=(1.525))+1)*W+X)+2)},easeInBounce:function(W){return 1-O.easeOutBounce(1-W)},easeOutBounce:function(W){if((W/=1)<(1/2.75)){return 1*(7.5625*W*W)}else{if(W<(2/2.75)){return 1*(7.5625*(W-=(1.5/2.75))*W+0.75)}else{if(W<(2.5/2.75)){return 1*(7.5625*(W-=(2.25/2.75))*W+0.9375)}else{return 1*(7.5625*(W-=(2.625/2.75))*W+0.984375)}}}},easeInOutBounce:function(W){if(W<1/2){return O.easeInBounce(W*2)*0.5}return O.easeOutBounce(W*2-1)*0.5+1*0.5}},d=H.requestAnimFrame=(function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(W){return window.setTimeout(W,1000/60)}})(),P=H.cancelAnimFrame=(function(){return window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.mozCancelAnimationFrame||window.oCancelAnimationFrame||window.msCancelAnimationFrame||function(W){return window.clearTimeout(W,1000/60)}})(),B=H.animationLoop=function(ab,W,aa,ac,Z,ae){var X=0,ad=O[aa]||O.linear;var Y=function(){X++;var ag=X/W;var af=ad(ag);ab.call(ae,af,ag,X);ac.call(ae,af,ag);if(X<W){ae.animationFrame=d(Y)}else{Z.apply(ae)}};d(Y)},C=H.getRelativePosition=function(W){var aa,Z;var ab=W.originalEvent||W,Y=W.currentTarget||W.srcElement,X=Y.getBoundingClientRect();if(ab.touches){aa=ab.touches[0].clientX-X.left;Z=ab.touches[0].clientY-X.top}else{aa=ab.clientX-X.left;Z=ab.clientY-X.top}return{x:aa,y:Z}},p=H.addEvent=function(X,W,Y){if(X.addEventListener){X.addEventListener(W,Y)}else{if(X.attachEvent){X.attachEvent("on"+W,Y)}else{X["on"+W]=Y}}},c=H.removeEvent=function(Y,W,X){if(Y.removeEventListener){Y.removeEventListener(W,X,false)}else{if(Y.detachEvent){Y.detachEvent("on"+W,X)}else{Y["on"+W]=Q}}},R=H.bindEvents=function(W,Y,X){if(!W.events){W.events={}}N(Y,function(Z){W.events[Z]=function(){X.apply(W,arguments)};p(W.chart.canvas,Z,W.events[Z])})},V=H.unbindEvents=function(W,X){N(X,function(Z,Y){c(W.chart.canvas,Y,Z)})},t=H.getMaximumWidth=function(X){var W=X.parentNode,Y=parseInt(K(W,"padding-left"))+parseInt(K(W,"padding-right"));return W?W.clientWidth-Y:0},o=H.getMaximumHeight=function(X){var W=X.parentNode,Y=parseInt(K(W,"padding-bottom"))+parseInt(K(W,"padding-top"));return W?W.clientHeight-Y:0},K=H.getStyle=function(W,X){return W.currentStyle?W.currentStyle[X]:document.defaultView.getComputedStyle(W,null).getPropertyValue(X)},x=H.getMaximumSize=H.getMaximumWidth,g=H.retinaScale=function(Z){var X=Z.ctx,Y=Z.canvas.width,W=Z.canvas.height;if(window.devicePixelRatio){X.canvas.style.width=Y+"px";X.canvas.style.height=W+"px";X.canvas.height=W*window.devicePixelRatio;X.canvas.width=Y*window.devicePixelRatio;X.scale(window.devicePixelRatio,window.devicePixelRatio)}},E=H.clear=function(W){W.ctx.clearRect(0,0,W.width,W.height)},f=H.fontString=function(X,Y,W){return Y+" "+X+"px "+W},w=H.longestText=function(W,X,Z){W.font=X;var Y=0;N(Z,function(aa){var ab=W.measureText(aa).width;Y=(ab>Y)?ab:Y});return Y},l=H.drawRoundedRectangle=function(Z,Y,ab,aa,X,W){Z.beginPath();Z.moveTo(Y+W,ab);Z.lineTo(Y+aa-W,ab);Z.quadraticCurveTo(Y+aa,ab,Y+aa,ab+W);Z.lineTo(Y+aa,ab+X-W);Z.quadraticCurveTo(Y+aa,ab+X,Y+aa-W,ab+X);Z.lineTo(Y+W,ab+X);Z.quadraticCurveTo(Y,ab+X,Y,ab+X-W);Z.lineTo(Y,ab+W);Z.quadraticCurveTo(Y,ab,Y+W,ab);Z.closePath()};G.instances={};G.Type=function(Y,W,X){this.options=W;this.chart=X;this.id=j();G.instances[this.id]=this;if(W.responsive){this.resize()}this.initialize.call(this,Y)};s(G.Type.prototype,{initialize:function(){return this},clear:function(){E(this.chart);return this},stop:function(){G.animationService.cancelAnimation(this);return this},resize:function(Z){this.stop();var X=this.chart.canvas,Y=t(this.chart.canvas),W=this.options.maintainAspectRatio?Y/this.chart.aspectRatio:o(this.chart.canvas);X.width=this.chart.width=Y;X.height=this.chart.height=W;g(this.chart);if(typeof Z==="function"){Z.apply(this,Array.prototype.slice.call(arguments,1))}return this},reflow:Q,render:function(W){if(W){this.reflow()}if(this.options.animation&&!W){var X=new G.Animation();X.numSteps=this.options.animationSteps;X.easing=this.options.animationEasing;X.render=function(Z,ab){var ac=H.easingEffects[ab.easing];var aa=ab.currentStep/ab.numSteps;var Y=ac(aa);Z.draw(Y,aa,ab.currentStep)};X.onAnimationProgress=this.options.onAnimationProgress;X.onAnimationComplete=this.options.onAnimationComplete;G.animationService.addAnimation(this,X)}else{this.draw();this.options.onAnimationComplete.call(this)}return this},generateLegend:function(){return H.template(this.options.legendTemplate,this)},destroy:function(){this.stop();this.clear();V(this,this.events);var W=this.chart.canvas;W.width=this.chart.width;W.height=this.chart.height;if(W.style.removeProperty){W.style.removeProperty("width");W.style.removeProperty("height")}else{W.style.removeAttribute("width");W.style.removeAttribute("height")}delete G.instances[this.id]},showTooltip:function(X,Y){if(typeof this.activeElements==="undefined"){this.activeElements=[]}var ad=(function(ag){var af=false;if(ag.length!==this.activeElements.length){af=true;return af}N(ag,function(ai,ah){if(ai!==this.activeElements[ah]){af=true}},this);return af}).call(this,X);if(!ad&&!Y){return}else{this.activeElements=X}this.draw();if(this.options.customTooltips){this.options.customTooltips(false)}if(X.length>0){if(this.datasets&&this.datasets.length>1){var ac,ab;for(var Z=this.datasets.length-1;Z>=0;Z--){ac=this.datasets[Z].points||this.datasets[Z].bars||this.datasets[Z].segments;ab=v(ac,X[0]);if(ab!==-1){break}}var aa=[],W=[],ae=(function(ak){var af=[],al,an=[],ai=[],aj,ah,ag,am;H.each(this.datasets,function(ao){al=ao.points||ao.bars||ao.segments;if(al[ab]&&al[ab].hasValue()){af.push(al[ab])}});H.each(af,function(ao){an.push(ao.x);ai.push(ao.y);aa.push(H.template(this.options.multiTooltipTemplate,ao));W.push({fill:ao._saved.fillColor||ao.fillColor,stroke:ao._saved.strokeColor||ao.strokeColor})},this);am=T(ai);ah=z(ai);ag=T(an);aj=z(an);return{x:(ag>this.chart.width/2)?ag:aj,y:(am+ah)/2}}).call(this,ab);new G.MultiTooltip({x:ae.x,y:ae.y,xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,xOffset:this.options.tooltipXOffset,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,titleTextColor:this.options.tooltipTitleFontColor,titleFontFamily:this.options.tooltipTitleFontFamily,titleFontStyle:this.options.tooltipTitleFontStyle,titleFontSize:this.options.tooltipTitleFontSize,cornerRadius:this.options.tooltipCornerRadius,labels:aa,legendColors:W,legendColorBackground:this.options.multiTooltipKeyBackground,title:i(this.options.tooltipTitleTemplate,X[0]),chart:this.chart,ctx:this.chart.ctx,custom:this.options.customTooltips}).draw()}else{N(X,function(af){var ag=af.tooltipPosition();new G.Tooltip({x:Math.round(ag.x),y:Math.round(ag.y),xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,caretHeight:this.options.tooltipCaretSize,cornerRadius:this.options.tooltipCornerRadius,text:i(this.options.tooltipTemplate,af),chart:this.chart,custom:this.options.customTooltips}).draw()},this)}}return this},toBase64Image:function(){return this.chart.canvas.toDataURL.apply(this.chart.canvas,arguments)}});G.Type.extend=function(aa){var Z=this;var Y=function(){return Z.apply(this,arguments)};Y.prototype=y(Z.prototype);s(Y.prototype,aa);Y.extend=G.Type.extend;if(aa.name||Z.prototype.name){var X=aa.name||Z.prototype.name;var W=(G.defaults[Z.prototype.name])?y(G.defaults[Z.prototype.name]):{};G.defaults[X]=s(W,aa.defaults);G.types[X]=Y;G.prototype[X]=function(ad,ac){var ab=L(G.defaults.global,G.defaults[X],ac||{});return new Y(ad,ab,this)}}else{r("Name not provided for this chart, so it hasn't been registered")}return Z};G.Element=function(W){s(this,W);this.initialize.apply(this,arguments);this.save()};s(G.Element.prototype,{initialize:function(){},restore:function(W){if(!W){s(this,this._saved)}else{N(W,function(X){this[X]=this._saved[X]},this)}return this},save:function(){this._saved=y(this);delete this._saved._saved;return this},update:function(W){N(W,function(Y,X){this._saved[X]=this[X];this[X]=Y},this);return this},transition:function(W,X){N(W,function(Z,Y){this[Y]=((Z-this._saved[Y])*X)+this._saved[Y]},this);return this},tooltipPosition:function(){return{x:this.x,y:this.y}},hasValue:function(){return U(this.value)}});G.Element.extend=h;G.Point=G.Element.extend({display:true,inRange:function(W,Y){var X=this.hitDetectionRadius+this.radius;return((Math.pow(W-this.x,2)+Math.pow(Y-this.y,2))<Math.pow(X,2))},draw:function(){if(this.display){var W=this.ctx;W.beginPath();W.arc(this.x,this.y,this.radius,0,Math.PI*2);W.closePath();W.strokeStyle=this.strokeColor;W.lineWidth=this.strokeWidth;W.fillStyle=this.fillColor;W.fill();W.stroke()}}});G.Arc=G.Element.extend({inRange:function(X,ad){var W=H.getAngleFromPoint(this,{x:X,y:ad});var Y=W.angle%(Math.PI*2),aa=(Math.PI*2+this.startAngle)%(Math.PI*2),Z=(Math.PI*2+this.endAngle)%(Math.PI*2)||360;var ac=(Z<aa)?Y<=Z||Y>=aa:Y>=aa&&Y<=Z;var ab=(W.distance>=this.innerRadius&&W.distance<=this.outerRadius);return(ac&&ab)},tooltipPosition:function(){var W=this.startAngle+((this.endAngle-this.startAngle)/2),X=(this.outerRadius-this.innerRadius)/2+this.innerRadius;return{x:this.x+(Math.cos(W)*X),y:this.y+(Math.sin(W)*X)}},draw:function(Y){var X=Y||1;var W=this.ctx;W.beginPath();W.arc(this.x,this.y,this.outerRadius<0?0:this.outerRadius,this.startAngle,this.endAngle);W.arc(this.x,this.y,this.innerRadius<0?0:this.innerRadius,this.endAngle,this.startAngle,true);W.closePath();W.strokeStyle=this.strokeColor;W.lineWidth=this.strokeWidth;W.fillStyle=this.fillColor;W.fill();W.lineJoin="bevel";if(this.showStroke){W.stroke()}}});G.Rectangle=G.Element.extend({draw:function(){var W=this.ctx,ab=this.width/2,Y=this.x-ab,X=this.x+ab,aa=this.base-(this.base-this.y),Z=this.strokeWidth/2;if(this.showStroke){Y+=Z;X-=Z;aa+=Z}W.beginPath();W.fillStyle=this.fillColor;W.strokeStyle=this.strokeColor;W.lineWidth=this.strokeWidth;W.moveTo(Y,this.base);W.lineTo(Y,aa);W.lineTo(X,aa);W.lineTo(X,this.base);W.fill();if(this.showStroke){W.stroke()}},height:function(){return this.base-this.y},inRange:function(W,X){return(W>=this.x-this.width/2&&W<=this.x+this.width/2)&&(X>=this.y&&X<=this.base)}});G.Animation=G.Element.extend({currentStep:null,numSteps:60,easing:"",render:null,onAnimationProgress:null,onAnimationComplete:null,});G.Tooltip=G.Element.extend({draw:function(){var Z=this.chart.ctx;Z.font=f(this.fontSize,this.fontStyle,this.fontFamily);this.xAlign="center";this.yAlign="above";var Y=this.caretPadding=2;var aa=Z.measureText(this.text).width+2*this.xPadding,X=this.fontSize+2*this.yPadding,ab=X+this.caretHeight+Y;if(this.x+aa/2>this.chart.width){this.xAlign="left"}else{if(this.x-aa/2<0){this.xAlign="right"}}if(this.y-ab<0){this.yAlign="below"}var W=this.x-aa/2,ac=this.y-ab;Z.fillStyle=this.fillColor;if(this.custom){this.custom(this)}else{switch(this.yAlign){case"above":Z.beginPath();Z.moveTo(this.x,this.y-Y);Z.lineTo(this.x+this.caretHeight,this.y-(Y+this.caretHeight));Z.lineTo(this.x-this.caretHeight,this.y-(Y+this.caretHeight));Z.closePath();Z.fill();break;case"below":ac=this.y+Y+this.caretHeight;Z.beginPath();Z.moveTo(this.x,this.y+Y);Z.lineTo(this.x+this.caretHeight,this.y+Y+this.caretHeight);Z.lineTo(this.x-this.caretHeight,this.y+Y+this.caretHeight);Z.closePath();Z.fill();break}switch(this.xAlign){case"left":W=this.x-aa+(this.cornerRadius+this.caretHeight);break;case"right":W=this.x-(this.cornerRadius+this.caretHeight);break}l(Z,W,ac,aa,X,this.cornerRadius);Z.fill();Z.fillStyle=this.textColor;Z.textAlign="center";Z.textBaseline="middle";Z.fillText(this.text,W+aa/2,ac+X/2)}}});G.MultiTooltip=G.Element.extend({initialize:function(){this.font=f(this.fontSize,this.fontStyle,this.fontFamily);this.titleFont=f(this.titleFontSize,this.titleFontStyle,this.titleFontFamily);this.titleHeight=this.title?this.titleFontSize*1.5:0;this.height=(this.labels.length*this.fontSize)+((this.labels.length-1)*(this.fontSize/2))+(this.yPadding*2)+this.titleHeight;this.ctx.font=this.titleFont;var Z=this.ctx.measureText(this.title).width,X=w(this.ctx,this.font,this.labels)+this.fontSize+3,Y=z([X,Z]);this.width=Y+(this.xPadding*2);var W=this.height/2;if(this.y-W<0){this.y=W}else{if(this.y+W>this.chart.height){this.y=this.chart.height-W}}if(this.x>this.chart.width/2){this.x-=this.xOffset+this.width}else{this.x+=this.xOffset}},getLineHeight:function(W){var Y=this.y-(this.height/2)+this.yPadding,X=W-1;if(W===0){return Y+this.titleHeight/3}else{return Y+((this.fontSize*1.5*X)+this.fontSize/2)+this.titleHeight}},draw:function(){if(this.custom){this.custom(this)}else{l(this.ctx,this.x,this.y-this.height/2,this.width,this.height,this.cornerRadius);var W=this.ctx;W.fillStyle=this.fillColor;W.fill();W.closePath();W.textAlign="left";W.textBaseline="middle";W.fillStyle=this.titleTextColor;W.font=this.titleFont;W.fillText(this.title,this.x+this.xPadding,this.getLineHeight(0));W.font=this.font;H.each(this.labels,function(Y,X){W.fillStyle=this.textColor;W.fillText(Y,this.x+this.xPadding+this.fontSize+3,this.getLineHeight(X+1));W.fillStyle=this.legendColorBackground;W.fillRect(this.x+this.xPadding,this.getLineHeight(X+1)-this.fontSize/2,this.fontSize,this.fontSize);W.fillStyle=this.legendColors[X].fill;W.fillRect(this.x+this.xPadding,this.getLineHeight(X+1)-this.fontSize/2,this.fontSize,this.fontSize)},this)}}});G.Scale=G.Element.extend({initialize:function(){this.fit()},buildYLabels:function(){this.yLabels=[];var X=F(this.stepValue);for(var W=0;W<=this.steps;W++){this.yLabels.push(i(this.templateString,{value:(this.min+(W*this.stepValue)).toFixed(X)}))}this.yLabelWidth=(this.display&&this.showLabels)?w(this.ctx,this.font,this.yLabels)+10:0},addXLabel:function(W){this.xLabels.push(W);this.valuesCount++;this.fit()},removeXLabel:function(){this.xLabels.shift();this.valuesCount--;this.fit()},fit:function(){this.startPoint=(this.display)?this.fontSize:0;this.endPoint=(this.display)?this.height-(this.fontSize*1.5)-5:this.height;this.startPoint+=this.padding;this.endPoint-=this.padding;var Y=this.endPoint;var X=this.endPoint-this.startPoint,W;this.calculateYRange(X);this.buildYLabels();this.calculateXLabelRotation();while((X>this.endPoint-this.startPoint)){X=this.endPoint-this.startPoint;W=this.yLabelWidth;this.calculateYRange(X);this.buildYLabels();if(W<this.yLabelWidth){this.endPoint=Y;this.calculateXLabelRotation()}}},calculateXLabelRotation:function(){this.ctx.font=this.font;var Y=this.ctx.measureText(this.xLabels[0]).width,W=this.ctx.measureText(this.xLabels[this.xLabels.length-1]).width,X,ad;this.xScalePaddingRight=W/2+3;this.xScalePaddingLeft=(Y/2>this.yLabelWidth)?Y/2:this.yLabelWidth;this.xLabelRotation=0;if(this.display){var Z=w(this.ctx,this.font,this.xLabels),ac,aa;this.xLabelWidth=Z;var ab=Math.floor(this.calculateX(1)-this.calculateX(0))-6;while((this.xLabelWidth>ab&&this.xLabelRotation===0)||(this.xLabelWidth>ab&&this.xLabelRotation<=90&&this.xLabelRotation>0)){ac=Math.cos(M(this.xLabelRotation));X=ac*Y;ad=ac*W;if(X+this.fontSize/2>this.yLabelWidth){this.xScalePaddingLeft=X+this.fontSize/2}this.xScalePaddingRight=this.fontSize/2;this.xLabelRotation++;this.xLabelWidth=ac*Z}if(this.xLabelRotation>0){this.endPoint-=Math.sin(M(this.xLabelRotation))*Z+3}}else{this.xLabelWidth=0;this.xScalePaddingRight=this.padding;this.xScalePaddingLeft=this.padding}},calculateYRange:Q,drawingArea:function(){return this.startPoint-this.endPoint},calculateY:function(X){var W=this.drawingArea()/(this.min-this.max);return this.endPoint-(W*(X-this.min))},calculateX:function(Y){var Z=(this.xLabelRotation>0),X=this.width-(this.xScalePaddingLeft+this.xScalePaddingRight),W=X/Math.max((this.valuesCount-((this.offsetGridLines)?0:1)),1),aa=(W*Y)+this.xScalePaddingLeft;if(this.offsetGridLines){aa+=(W/2)}return Math.round(aa)},update:function(W){H.extend(this,W);this.fit()},draw:function(){var W=this.ctx,X=(this.endPoint-this.startPoint)/this.steps,Y=Math.round(this.xScalePaddingLeft);if(this.display){W.fillStyle=this.textColor;W.font=this.font;N(this.yLabels,function(ab,aa){var ac=this.endPoint-(X*aa),ad=Math.round(ac),Z=this.showHorizontalLines;W.textAlign="right";W.textBaseline="middle";if(this.showLabels){W.fillText(ab,Y-10,ac)}if(aa===0&&!Z){Z=true}if(Z){W.beginPath()}if(aa>0){W.lineWidth=this.gridLineWidth;W.strokeStyle=this.gridLineColor}else{W.lineWidth=this.lineWidth;W.strokeStyle=this.lineColor}ad+=H.aliasPixel(W.lineWidth);if(Z){W.moveTo(Y,ad);W.lineTo(this.width,ad);W.stroke();W.closePath()}W.lineWidth=this.lineWidth;W.strokeStyle=this.lineColor;W.beginPath();W.moveTo(Y-5,ad);W.lineTo(Y,ad);W.stroke();W.closePath()},this);N(this.xLabels,function(aa,Z){var ad=this.calculateX(Z)+q(this.lineWidth),ab=this.calculateX(Z-(this.offsetGridLines?0.5:0))+q(this.lineWidth),ac=(this.xLabelRotation>0),ae=this.showVerticalLines;if(Z===0&&!ae){ae=true}if(ae){W.beginPath()}if(Z>0){W.lineWidth=this.gridLineWidth;W.strokeStyle=this.gridLineColor}else{W.lineWidth=this.lineWidth;W.strokeStyle=this.lineColor}if(ae){W.moveTo(ab,this.endPoint);W.lineTo(ab,this.startPoint-3);W.stroke();W.closePath()}W.lineWidth=this.lineWidth;W.strokeStyle=this.lineColor;W.beginPath();W.moveTo(ab,this.endPoint);W.lineTo(ab,this.endPoint+5);W.stroke();W.closePath();W.save();W.translate(ad,(ac)?this.endPoint+12:this.endPoint+8);W.rotate(M(this.xLabelRotation)*-1);W.font=this.font;W.textAlign=(ac)?"right":"center";W.textBaseline=(ac)?"middle":"top";W.fillText(aa,0,0);W.restore()},this)}}});G.RadialScale=G.Element.extend({initialize:function(){this.size=T([this.height,this.width]);this.drawingArea=(this.display)?(this.size/2)-(this.fontSize/2+this.backdropPaddingY):(this.size/2)},calculateCenterOffset:function(X){var W=this.drawingArea/(this.max-this.min);return(X-this.min)*W},update:function(){if(!this.lineArc){this.setScaleSize()}else{this.drawingArea=(this.display)?(this.size/2)-(this.fontSize/2+this.backdropPaddingY):(this.size/2)}this.buildYLabels()},buildYLabels:function(){this.yLabels=[];var X=F(this.stepValue);for(var W=0;W<=this.steps;W++){this.yLabels.push(i(this.templateString,{value:(this.min+(W*this.stepValue)).toFixed(X)}))}},getCircumference:function(){return((Math.PI*2)/this.valuesCount)},setScaleSize:function(){var W=T([(this.height/2-this.pointLabelFontSize-5),this.width/2]),ak,aa,ah,Z,al=this.width,aj,ad,ac=0,ag,Y,ai,af,ab,X,ae;this.ctx.font=f(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily);for(aa=0;aa<this.valuesCount;aa++){ak=this.getPointPosition(aa,W);ah=this.ctx.measureText(i(this.templateString,{value:this.labels[aa]})).width+5;if(aa===0||aa===this.valuesCount/2){Z=ah/2;if(ak.x+Z>al){al=ak.x+Z;aj=aa}if(ak.x-Z<ac){ac=ak.x-Z;ag=aa}}else{if(aa<this.valuesCount/2){if(ak.x+ah>al){al=ak.x+ah;aj=aa}}else{if(aa>this.valuesCount/2){if(ak.x-ah<ac){ac=ak.x-ah;ag=aa}}}}}ai=ac;af=Math.ceil(al-this.width);ad=this.getIndexAngle(aj);Y=this.getIndexAngle(ag);ab=af/Math.sin(ad+Math.PI/2);X=ai/Math.sin(Y+Math.PI/2);ab=(U(ab))?ab:0;X=(U(X))?X:0;this.drawingArea=W-(X+ab)/2;this.setCenterPoint(X,ab)},setCenterPoint:function(Z,W){var Y=this.width-W-this.drawingArea,X=Z+this.drawingArea;this.xCenter=(X+Y)/2;this.yCenter=(this.height/2)},getIndexAngle:function(X){var W=(Math.PI*2)/this.valuesCount;return X*W-(Math.PI/2)},getPointPosition:function(X,Y){var W=this.getIndexAngle(X);return{x:(Math.cos(W)*Y)+this.xCenter,y:(Math.sin(W)*Y)+this.yCenter}},draw:function(){if(this.display){var aj=this.ctx;N(this.yLabels,function(ao,an){if(an>0){var am=an*(this.drawingArea/this.steps),al=this.yCenter-am,aq;if(this.lineWidth>0){aj.strokeStyle=this.lineColor;aj.lineWidth=this.lineWidth;if(this.lineArc){aj.beginPath();aj.arc(this.xCenter,this.yCenter,am,0,Math.PI*2);aj.closePath();aj.stroke()}else{aj.beginPath();for(var ap=0;ap<this.valuesCount;ap++){aq=this.getPointPosition(ap,this.calculateCenterOffset(this.min+(an*this.stepValue)));if(ap===0){aj.moveTo(aq.x,aq.y)}else{aj.lineTo(aq.x,aq.y)}}aj.closePath();aj.stroke()}}if(this.showLabels){aj.font=f(this.fontSize,this.fontStyle,this.fontFamily);if(this.showLabelBackdrop){var ak=aj.measureText(ao).width;aj.fillStyle=this.backdropColor;aj.fillRect(this.xCenter-ak/2-this.backdropPaddingX,al-this.fontSize/2-this.backdropPaddingY,ak+this.backdropPaddingX*2,this.fontSize+this.backdropPaddingY*2)}aj.textAlign="center";aj.textBaseline="middle";aj.fillStyle=this.fontColor;aj.fillText(ao,this.xCenter,al)}}},this);if(!this.lineArc){aj.lineWidth=this.angleLineWidth;aj.strokeStyle=this.angleLineColor;for(var ab=this.valuesCount-1;ab>=0;ab--){var ag=null,X=null;if(this.angleLineWidth>0&&(ab%this.angleLineInterval===0)){ag=this.calculateCenterOffset(this.max);X=this.getPointPosition(ab,ag);aj.beginPath();aj.moveTo(this.xCenter,this.yCenter);aj.lineTo(X.x,X.y);aj.stroke();aj.closePath()}if(this.backgroundColors&&this.backgroundColors.length==this.valuesCount){if(ag==null){ag=this.calculateCenterOffset(this.max)}if(X==null){X=this.getPointPosition(ab,ag)}var Z=this.getPointPosition(ab===0?this.valuesCount-1:ab-1,ag);var ai=this.getPointPosition(ab===this.valuesCount-1?0:ab+1,ag);var Y={x:(Z.x+X.x)/2,y:(Z.y+X.y)/2};var aa={x:(X.x+ai.x)/2,y:(X.y+ai.y)/2};aj.beginPath();aj.moveTo(this.xCenter,this.yCenter);aj.lineTo(Y.x,Y.y);aj.lineTo(X.x,X.y);aj.lineTo(aa.x,aa.y);aj.fillStyle=this.backgroundColors[ab];aj.fill();aj.closePath()}var ae=this.getPointPosition(ab,this.calculateCenterOffset(this.max)+5);aj.font=f(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily);aj.fillStyle=this.pointLabelFontColor;var W=this.labels.length,ac=this.labels.length/2,ah=ac/2,af=(ab<ah||ab>W-ah),ad=(ab===ah||ab===W-ah);if(ab===0){aj.textAlign="center"}else{if(ab===ac){aj.textAlign="center"}else{if(ab<ac){aj.textAlign="left"}else{aj.textAlign="right"}}}if(ad){aj.textBaseline="middle"}else{if(af){aj.textBaseline="bottom"}else{aj.textBaseline="top"}}aj.fillText(this.labels[ab],ae.x,ae.y)}}}}});G.animationService={frameDuration:17,animations:[],dropFrames:0,addAnimation:function(W,Y){for(var X=0;X<this.animations.length;++X){if(this.animations[X].chartInstance===W){this.animations[X].animationObject=Y;return}}this.animations.push({chartInstance:W,animationObject:Y});if(this.animations.length==1){H.requestAnimFrame.call(window,this.digestWrapper)}},cancelAnimation:function(W){var X=H.findNextWhere(this.animations,function(Y){return Y.chartInstance===W});if(X){this.animations.splice(X,1)}},digestWrapper:function(){G.animationService.startDigest.call(G.animationService)},startDigest:function(){var aa=Date.now();var W=0;if(this.dropFrames>1){W=Math.floor(this.dropFrames);this.dropFrames-=W}for(var Z=0;Z<this.animations.length;Z++){if(this.animations[Z].animationObject.currentStep===null){this.animations[Z].animationObject.currentStep=0}this.animations[Z].animationObject.currentStep+=1+W;if(this.animations[Z].animationObject.currentStep>this.animations[Z].animationObject.numSteps){this.animations[Z].animationObject.currentStep=this.animations[Z].animationObject.numSteps}this.animations[Z].animationObject.render(this.animations[Z].chartInstance,this.animations[Z].animationObject);if(this.animations[Z].animationObject.currentStep==this.animations[Z].animationObject.numSteps){this.animations[Z].animationObject.onAnimationComplete.call(this.animations[Z].chartInstance);this.animations.splice(Z,1);Z--}}var X=Date.now();var Y=X-aa-this.frameDuration;var ab=Y/this.frameDuration;if(ab>1){this.dropFrames+=ab}if(this.animations.length>0){H.requestAnimFrame.call(window,this.digestWrapper)}}};H.addEvent(window,"resize",(function(){var W;return function(){clearTimeout(W);W=setTimeout(function(){N(G.instances,function(X){if(X.options.responsive){X.resize(X.render,true)}})},50)}})());if(k){define("Chart",[],function(){return G})}else{if(typeof module==="object"&&module.exports){module.exports=G}}A.Chart=G;G.noConflict=function(){A.Chart=J;return G}}).call(this);(function(){var c=this,b=c.Chart,d=b.helpers;var a={scaleBeginAtZero:true,scaleShowGridLines:true,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:true,scaleShowVerticalLines:true,barShowStroke:true,barStrokeWidth:2,barValueSpacing:5,barDatasetSpacing:1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=datasets[i].fillColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(datasets[i].label){%><%=datasets[i].label%><%}%></span></li><%}%></ul>'};b.Type.extend({name:"Bar",defaults:a,initialize:function(f){var e=this.options;this.ScaleClass=b.Scale.extend({offsetGridLines:true,calculateBarX:function(g,l,i){var h=this.calculateBaseWidth(),k=this.calculateX(i)-(h/2),j=this.calculateBarWidth(g);return k+(j*l)+(l*e.barDatasetSpacing)+j/2},calculateBaseWidth:function(){return(this.calculateX(1)-this.calculateX(0))-(2*e.barValueSpacing)},calculateBarWidth:function(h){var g=this.calculateBaseWidth()-((h-1)*e.barDatasetSpacing);return(g/h)}});this.datasets=[];if(this.options.showTooltips){d.bindEvents(this,this.options.tooltipEvents,function(g){var h=(g.type!=="mouseout")?this.getBarsAtEvent(g):[];this.eachBars(function(i){i.restore(["fillColor","strokeColor"])});d.each(h,function(i){if(i){i.fillColor=i.highlightFill;i.strokeColor=i.highlightStroke}});this.showTooltip(h)})}this.BarClass=b.Rectangle.extend({strokeWidth:this.options.barStrokeWidth,showStroke:this.options.barShowStroke,ctx:this.chart.ctx});d.each(f.datasets,function(h,i){var g={label:h.label||null,fillColor:h.fillColor,strokeColor:h.strokeColor,bars:[]};this.datasets.push(g);d.each(h.data,function(j,k){g.bars.push(new this.BarClass({value:j,label:f.labels[k],datasetLabel:h.label,strokeColor:(typeof h.strokeColor=="object")?h.strokeColor[k]:h.strokeColor,fillColor:(typeof h.fillColor=="object")?h.fillColor[k]:h.fillColor,highlightFill:(h.highlightFill)?(typeof h.highlightFill=="object")?h.highlightFill[k]:h.highlightFill:(typeof h.fillColor=="object")?h.fillColor[k]:h.fillColor,highlightStroke:(h.highlightStroke)?(typeof h.highlightStroke=="object")?h.highlightStroke[k]:h.highlightStroke:(typeof h.strokeColor=="object")?h.strokeColor[k]:h.strokeColor}))},this)},this);this.buildScale(f.labels);this.BarClass.prototype.base=this.scale.endPoint;this.eachBars(function(h,g,i){d.extend(h,{width:this.scale.calculateBarWidth(this.datasets.length),x:this.scale.calculateBarX(this.datasets.length,i,g),y:this.scale.endPoint});h.save()},this);this.render()},update:function(){this.scale.update();d.each(this.activeElements,function(e){e.restore(["fillColor","strokeColor"])});this.eachBars(function(e){e.save()});this.render()},eachBars:function(e){d.each(this.datasets,function(f,g){d.each(f.bars,e,this,g)},this)},getBarsAtEvent:function(j){var g=[],i=d.getRelativePosition(j),f=function(e){g.push(e.bars[h])},h;for(var k=0;k<this.datasets.length;k++){for(h=0;h<this.datasets[k].bars.length;h++){if(this.datasets[k].bars[h].inRange(i.x,i.y)){d.each(this.datasets,f);return g}}}return g},buildScale:function(h){var f=this;var g=function(){var i=[];f.eachBars(function(j){i.push(j.value)});return i};var e={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:h.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(j){var i=d.calculateScaleRange(g(),j,this.fontSize,this.beginAtZero,this.integersOnly);d.extend(this,i)},xLabels:h,font:d.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:(this.options.scaleShowGridLines)?this.options.scaleGridLineWidth:0,gridLineColor:(this.options.scaleShowGridLines)?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:(this.options.showScale)?0:(this.options.barShowStroke)?this.options.barStrokeWidth:0,showLabels:this.options.scaleShowLabels,display:this.options.showScale};if(this.options.scaleOverride){d.extend(e,{calculateYRange:d.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+(this.options.scaleSteps*this.options.scaleStepWidth)})}this.scale=new this.ScaleClass(e)},addData:function(f,e){d.each(f,function(g,h){this.datasets[h].bars.push(new this.BarClass({value:g,label:e,datasetLabel:this.datasets[h].label,x:this.scale.calculateBarX(this.datasets.length,h,this.scale.valuesCount+1),y:this.scale.endPoint,width:this.scale.calculateBarWidth(this.datasets.length),base:this.scale.endPoint,strokeColor:this.datasets[h].strokeColor,fillColor:this.datasets[h].fillColor}))},this);this.scale.addXLabel(e);this.update()},removeData:function(){this.scale.removeXLabel();d.each(this.datasets,function(e){e.bars.shift()},this);this.update()},reflow:function(){d.extend(this.BarClass.prototype,{y:this.scale.endPoint,base:this.scale.endPoint});var e=d.extend({height:this.chart.height,width:this.chart.width});this.scale.update(e)},draw:function(g){var f=g||1;this.clear();var e=this.chart.ctx;this.scale.draw(f);d.each(this.datasets,function(h,i){d.each(h.bars,function(k,j){if(k.hasValue()){k.base=this.scale.endPoint;k.transition({x:this.scale.calculateBarX(this.datasets.length,i,j),y:this.scale.calculateY(k.value),width:this.scale.calculateBarWidth(this.datasets.length)},f).draw()}},this)},this)}})}).call(this);(function(){var c=this,b=c.Chart,d=b.helpers;var a={segmentShowStroke:true,segmentStrokeColor:"#fff",segmentStrokeWidth:2,percentageInnerCutout:50,animationSteps:100,animationEasing:"easeOutBounce",animateRotate:true,animateScale:false,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=segments[i].fillColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(segments[i].label){%><%=segments[i].label%><%}%></span></li><%}%></ul>'};b.Type.extend({name:"Doughnut",defaults:a,initialize:function(e){this.segments=[];this.outerRadius=(d.min([this.chart.width,this.chart.height])-this.options.segmentStrokeWidth/2)/2;this.SegmentArc=b.Arc.extend({ctx:this.chart.ctx,x:this.chart.width/2,y:this.chart.height/2});if(this.options.showTooltips){d.bindEvents(this,this.options.tooltipEvents,function(f){var g=(f.type!=="mouseout")?this.getSegmentsAtEvent(f):[];d.each(this.segments,function(h){h.restore(["fillColor"])});d.each(g,function(h){h.fillColor=h.highlightColor});this.showTooltip(g)})}this.calculateTotal(e);d.each(e,function(g,f){if(!g.color){g.color="hsl("+(360*f/e.length)+", 100%, 50%)"}this.addData(g,f,true)},this);this.render()},getSegmentsAtEvent:function(h){var g=[];var f=d.getRelativePosition(h);d.each(this.segments,function(e){if(e.inRange(f.x,f.y)){g.push(e)}},this);return g},addData:function(h,g,e){var f=g!==undefined?g:this.segments.length;if(typeof(h.color)==="undefined"){h.color=b.defaults.global.segmentColorDefault[f%b.defaults.global.segmentColorDefault.length];h.highlight=b.defaults.global.segmentHighlightColorDefaults[f%b.defaults.global.segmentHighlightColorDefaults.length]}this.segments.splice(f,0,new this.SegmentArc({value:h.value,outerRadius:(this.options.animateScale)?0:this.outerRadius,innerRadius:(this.options.animateScale)?0:(this.outerRadius/100)*this.options.percentageInnerCutout,fillColor:h.color,highlightColor:h.highlight||h.color,showStroke:this.options.segmentShowStroke,strokeWidth:this.options.segmentStrokeWidth,strokeColor:this.options.segmentStrokeColor,startAngle:Math.PI*1.5,circumference:(this.options.animateRotate)?0:this.calculateCircumference(h.value),label:h.label}));if(!e){this.reflow();this.update()}},calculateCircumference:function(e){if(this.total>0){return(Math.PI*2)*(e/this.total)}else{return 0}},calculateTotal:function(e){this.total=0;d.each(e,function(f){this.total+=Math.abs(f.value)},this)},update:function(){this.calculateTotal(this.segments);d.each(this.activeElements,function(e){e.restore(["fillColor"])});d.each(this.segments,function(e){e.save()});this.render()},removeData:function(f){var e=(d.isNumber(f))?f:this.segments.length-1;this.segments.splice(e,1);this.reflow();this.update()},reflow:function(){d.extend(this.SegmentArc.prototype,{x:this.chart.width/2,y:this.chart.height/2});this.outerRadius=(d.min([this.chart.width,this.chart.height])-this.options.segmentStrokeWidth/2)/2;d.each(this.segments,function(e){e.update({outerRadius:this.outerRadius,innerRadius:(this.outerRadius/100)*this.options.percentageInnerCutout})},this)},draw:function(e){var f=(e)?e:1;this.clear();d.each(this.segments,function(h,g){h.transition({circumference:this.calculateCircumference(h.value),outerRadius:this.outerRadius,innerRadius:(this.outerRadius/100)*this.options.percentageInnerCutout},f);h.endAngle=h.startAngle+h.circumference;h.draw();if(g===0){h.startAngle=Math.PI*1.5}if(g<this.segments.length-1){this.segments[g+1].startAngle=h.endAngle}},this)}});b.types.Doughnut.extend({name:"Pie",defaults:d.merge(a,{percentageInnerCutout:0})})}).call(this);(function(){var c=this,b=c.Chart,d=b.helpers;var a={scaleShowGridLines:true,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:true,scaleShowVerticalLines:true,bezierCurve:true,bezierCurveTension:0.4,pointDot:true,pointDotRadius:4,pointDotStrokeWidth:1,pointHitDetectionRadius:20,datasetStroke:true,datasetStrokeWidth:2,datasetFill:true,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=datasets[i].strokeColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(datasets[i].label){%><%=datasets[i].label%><%}%></span></li><%}%></ul>',offsetGridLines:false};b.Type.extend({name:"Line",defaults:a,initialize:function(e){this.PointClass=b.Point.extend({offsetGridLines:this.options.offsetGridLines,strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx,inRange:function(f){return(Math.pow(f-this.x,2)<Math.pow(this.radius+this.hitDetectionRadius,2))}});this.datasets=[];if(this.options.showTooltips){d.bindEvents(this,this.options.tooltipEvents,function(f){var g=(f.type!=="mouseout")?this.getPointsAtEvent(f):[];this.eachPoints(function(h){h.restore(["fillColor","strokeColor"])});d.each(g,function(h){h.fillColor=h.highlightFill;h.strokeColor=h.highlightStroke});this.showTooltip(g)})}d.each(e.datasets,function(g){var f={label:g.label||null,fillColor:g.fillColor,strokeColor:g.strokeColor,pointColor:g.pointColor,pointStrokeColor:g.pointStrokeColor,points:[]};this.datasets.push(f);d.each(g.data,function(h,i){f.points.push(new this.PointClass({value:h,label:e.labels[i],datasetLabel:g.label,strokeColor:g.pointStrokeColor,fillColor:g.pointColor,highlightFill:g.pointHighlightFill||g.pointColor,highlightStroke:g.pointHighlightStroke||g.pointStrokeColor}))},this);this.buildScale(e.labels);this.eachPoints(function(h,i){d.extend(h,{x:this.scale.calculateX(i),y:this.scale.endPoint});h.save()},this)},this);this.render()},update:function(){this.scale.update();d.each(this.activeElements,function(e){e.restore(["fillColor","strokeColor"])});this.eachPoints(function(e){e.save()});this.render()},eachPoints:function(e){d.each(this.datasets,function(f){d.each(f.points,e,this)},this)},getPointsAtEvent:function(g){var h=[],f=d.getRelativePosition(g);d.each(this.datasets,function(e){d.each(e.points,function(i){if(i.inRange(f.x,f.y)){h.push(i)}})},this);return h},buildScale:function(h){var f=this;var g=function(){var i=[];f.eachPoints(function(j){i.push(j.value)});return i};var e={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,offsetGridLines:this.options.offsetGridLines,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:h.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(j){var i=d.calculateScaleRange(g(),j,this.fontSize,this.beginAtZero,this.integersOnly);d.extend(this,i)},xLabels:h,font:d.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:(this.options.scaleShowGridLines)?this.options.scaleGridLineWidth:0,gridLineColor:(this.options.scaleShowGridLines)?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:(this.options.showScale)?0:this.options.pointDotRadius+this.options.pointDotStrokeWidth,showLabels:this.options.scaleShowLabels,display:this.options.showScale};if(this.options.scaleOverride){d.extend(e,{calculateYRange:d.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+(this.options.scaleSteps*this.options.scaleStepWidth)})}this.scale=new b.Scale(e)},addData:function(f,e){d.each(f,function(g,h){this.datasets[h].points.push(new this.PointClass({value:g,label:e,datasetLabel:this.datasets[h].label,x:this.scale.calculateX(this.scale.valuesCount+1),y:this.scale.endPoint,strokeColor:this.datasets[h].pointStrokeColor,fillColor:this.datasets[h].pointColor}))},this);this.scale.addXLabel(e);this.update()},removeData:function(){this.scale.removeXLabel();d.each(this.datasets,function(e){e.points.shift()},this);this.update()},reflow:function(){var e=d.extend({height:this.chart.height,width:this.chart.width});this.scale.update(e)},draw:function(j){var f=j||1;this.clear();var e=this.chart.ctx;var g=function(k){return k.value!==null},i=function(k,m,l){return d.findNextWhere(m,g,l)||k},h=function(k,m,l){return d.findPreviousWhere(m,g,l)||k};if(!this.scale){return}this.scale.draw(f);d.each(this.datasets,function(l){var k=d.where(l.points,g);d.each(l.points,function(m,n){if(m.hasValue()){m.transition({y:this.scale.calculateY(m.value),x:this.scale.calculateX(n)},f)}},this);if(this.options.bezierCurve){d.each(k,function(m,n){var o=(n>0&&n<k.length-1)?this.options.bezierCurveTension:0;m.controlPoints=d.splineCurve(h(m,k,n),m,i(m,k,n),o);if(m.controlPoints.outer.y>this.scale.endPoint){m.controlPoints.outer.y=this.scale.endPoint}else{if(m.controlPoints.outer.y<this.scale.startPoint){m.controlPoints.outer.y=this.scale.startPoint}}if(m.controlPoints.inner.y>this.scale.endPoint){m.controlPoints.inner.y=this.scale.endPoint}else{if(m.controlPoints.inner.y<this.scale.startPoint){m.controlPoints.inner.y=this.scale.startPoint}}},this)}e.lineWidth=this.options.datasetStrokeWidth;e.strokeStyle=l.strokeColor;e.beginPath();d.each(k,function(m,n){if(n===0){e.moveTo(m.x,m.y)}else{if(this.options.bezierCurve){var o=h(m,k,n);e.bezierCurveTo(o.controlPoints.outer.x,o.controlPoints.outer.y,m.controlPoints.inner.x,m.controlPoints.inner.y,m.x,m.y)}else{e.lineTo(m.x,m.y)}}},this);if(this.options.datasetStroke){e.stroke()}if(this.options.datasetFill&&k.length>0){e.lineTo(k[k.length-1].x,this.scale.endPoint);e.lineTo(k[0].x,this.scale.endPoint);e.fillStyle=l.fillColor;e.closePath();e.fill()}d.each(k,function(m){m.draw()})},this)}})}).call(this);(function(){var c=this,b=c.Chart,d=b.helpers;var a={scaleShowLabelBackdrop:true,scaleBackdropColor:"rgba(255,255,255,0.75)",scaleBeginAtZero:true,scaleBackdropPaddingY:2,scaleBackdropPaddingX:2,scaleShowLine:true,segmentShowStroke:true,segmentStrokeColor:"#fff",segmentStrokeWidth:2,animationSteps:100,animationEasing:"easeOutBounce",animateRotate:true,animateScale:false,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=segments[i].fillColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(segments[i].label){%><%=segments[i].label%><%}%></span></li><%}%></ul>'};b.Type.extend({name:"PolarArea",defaults:a,initialize:function(e){this.segments=[];this.SegmentArc=b.Arc.extend({showStroke:this.options.segmentShowStroke,strokeWidth:this.options.segmentStrokeWidth,strokeColor:this.options.segmentStrokeColor,ctx:this.chart.ctx,innerRadius:0,x:this.chart.width/2,y:this.chart.height/2});this.scale=new b.RadialScale({display:this.options.showScale,fontStyle:this.options.scaleFontStyle,fontSize:this.options.scaleFontSize,fontFamily:this.options.scaleFontFamily,fontColor:this.options.scaleFontColor,showLabels:this.options.scaleShowLabels,showLabelBackdrop:this.options.scaleShowLabelBackdrop,backdropColor:this.options.scaleBackdropColor,backdropPaddingY:this.options.scaleBackdropPaddingY,backdropPaddingX:this.options.scaleBackdropPaddingX,lineWidth:(this.options.scaleShowLine)?this.options.scaleLineWidth:0,lineColor:this.options.scaleLineColor,lineArc:true,width:this.chart.width,height:this.chart.height,xCenter:this.chart.width/2,yCenter:this.chart.height/2,ctx:this.chart.ctx,templateString:this.options.scaleLabel,valuesCount:e.length});this.updateScaleRange(e);this.scale.update();d.each(e,function(g,f){this.addData(g,f,true)},this);if(this.options.showTooltips){d.bindEvents(this,this.options.tooltipEvents,function(f){var g=(f.type!=="mouseout")?this.getSegmentsAtEvent(f):[];d.each(this.segments,function(h){h.restore(["fillColor"])});d.each(g,function(h){h.fillColor=h.highlightColor});this.showTooltip(g)})}this.render()},getSegmentsAtEvent:function(h){var g=[];var f=d.getRelativePosition(h);d.each(this.segments,function(e){if(e.inRange(f.x,f.y)){g.push(e)}},this);return g},addData:function(h,g,e){var f=g||this.segments.length;this.segments.splice(f,0,new this.SegmentArc({fillColor:h.color,highlightColor:h.highlight||h.color,label:h.label,value:h.value,outerRadius:(this.options.animateScale)?0:this.scale.calculateCenterOffset(h.value),circumference:(this.options.animateRotate)?0:this.scale.getCircumference(),startAngle:Math.PI*1.5}));if(!e){this.reflow();this.update()}},removeData:function(f){var e=(d.isNumber(f))?f:this.segments.length-1;this.segments.splice(e,1);this.reflow();this.update()},calculateTotal:function(e){this.total=0;d.each(e,function(f){this.total+=f.value},this);this.scale.valuesCount=this.segments.length},updateScaleRange:function(f){var e=[];d.each(f,function(h){e.push(h.value)});var g=(this.options.scaleOverride)?{steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+(this.options.scaleSteps*this.options.scaleStepWidth)}:d.calculateScaleRange(e,d.min([this.chart.width,this.chart.height])/2,this.options.scaleFontSize,this.options.scaleBeginAtZero,this.options.scaleIntegersOnly);d.extend(this.scale,g,{size:d.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2})},update:function(){this.calculateTotal(this.segments);d.each(this.segments,function(e){e.save()});this.reflow();this.render()},reflow:function(){d.extend(this.SegmentArc.prototype,{x:this.chart.width/2,y:this.chart.height/2});this.updateScaleRange(this.segments);this.scale.update();d.extend(this.scale,{xCenter:this.chart.width/2,yCenter:this.chart.height/2});d.each(this.segments,function(e){e.update({outerRadius:this.scale.calculateCenterOffset(e.value)})},this)},draw:function(f){var e=f||1;this.clear();d.each(this.segments,function(h,g){h.transition({circumference:this.scale.getCircumference(),outerRadius:this.scale.calculateCenterOffset(h.value)},e);h.endAngle=h.startAngle+h.circumference;if(g===0){h.startAngle=Math.PI*1.5}if(g<this.segments.length-1){this.segments[g+1].startAngle=h.endAngle}h.draw()},this);this.scale.draw()}})}).call(this);(function(){var b=this,a=b.Chart,c=a.helpers;a.Type.extend({name:"Radar",defaults:{scaleShowLine:true,angleShowLineOut:true,scaleShowLabels:false,scaleBeginAtZero:true,angleLineColor:"rgba(0,0,0,.1)",angleLineWidth:1,angleLineInterval:1,pointLabelFontFamily:"'Arial'",pointLabelFontStyle:"normal",pointLabelFontSize:10,pointLabelFontColor:"#666",pointDot:true,pointDotRadius:3,pointDotStrokeWidth:1,pointHitDetectionRadius:20,datasetStroke:true,datasetStrokeWidth:2,datasetFill:true,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=datasets[i].strokeColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(datasets[i].label){%><%=datasets[i].label%><%}%></span></li><%}%></ul>'},initialize:function(d){this.PointClass=a.Point.extend({strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx});this.datasets=[];this.buildScale(d);if(this.options.showTooltips){c.bindEvents(this,this.options.tooltipEvents,function(e){var f=(e.type!=="mouseout")?this.getPointsAtEvent(e):[];this.eachPoints(function(g){g.restore(["fillColor","strokeColor"])});c.each(f,function(g){g.fillColor=g.highlightFill;g.strokeColor=g.highlightStroke});this.showTooltip(f)})}c.each(d.datasets,function(f){var e={label:f.label||null,fillColor:f.fillColor,strokeColor:f.strokeColor,pointColor:f.pointColor,pointStrokeColor:f.pointStrokeColor,points:[]};this.datasets.push(e);c.each(f.data,function(g,h){var i;if(!this.scale.animation){i=this.scale.getPointPosition(h,this.scale.calculateCenterOffset(g))}e.points.push(new this.PointClass({value:g,label:d.labels[h],datasetLabel:f.label,x:(this.options.animation)?this.scale.xCenter:i.x,y:(this.options.animation)?this.scale.yCenter:i.y,strokeColor:f.pointStrokeColor,fillColor:f.pointColor,highlightFill:f.pointHighlightFill||f.pointColor,highlightStroke:f.pointHighlightStroke||f.pointStrokeColor}))},this)},this);this.render()},eachPoints:function(d){c.each(this.datasets,function(e){c.each(e.points,d,this)},this)},getPointsAtEvent:function(d){var i=c.getRelativePosition(d),f=c.getAngleFromPoint({x:this.scale.xCenter,y:this.scale.yCenter},i);var e=(Math.PI*2)/this.scale.valuesCount,g=Math.round((f.angle-Math.PI*1.5)/e),h=[];if(g>=this.scale.valuesCount||g<0){g=0}if(f.distance<=this.scale.drawingArea){c.each(this.datasets,function(j){h.push(j.points[g])})}return h},buildScale:function(d){this.scale=new a.RadialScale({display:this.options.showScale,fontStyle:this.options.scaleFontStyle,fontSize:this.options.scaleFontSize,fontFamily:this.options.scaleFontFamily,fontColor:this.options.scaleFontColor,showLabels:this.options.scaleShowLabels,showLabelBackdrop:this.options.scaleShowLabelBackdrop,backdropColor:this.options.scaleBackdropColor,backgroundColors:this.options.scaleBackgroundColors,backdropPaddingY:this.options.scaleBackdropPaddingY,backdropPaddingX:this.options.scaleBackdropPaddingX,lineWidth:(this.options.scaleShowLine)?this.options.scaleLineWidth:0,lineColor:this.options.scaleLineColor,angleLineColor:this.options.angleLineColor,angleLineWidth:(this.options.angleShowLineOut)?this.options.angleLineWidth:0,angleLineInterval:(this.options.angleLineInterval)?this.options.angleLineInterval:1,pointLabelFontColor:this.options.pointLabelFontColor,pointLabelFontSize:this.options.pointLabelFontSize,pointLabelFontFamily:this.options.pointLabelFontFamily,pointLabelFontStyle:this.options.pointLabelFontStyle,height:this.chart.height,width:this.chart.width,xCenter:this.chart.width/2,yCenter:this.chart.height/2,ctx:this.chart.ctx,templateString:this.options.scaleLabel,labels:d.labels,valuesCount:d.datasets[0].data.length});this.scale.setScaleSize();this.updateScaleRange(d.datasets);this.scale.buildYLabels()},updateScaleRange:function(e){var d=(function(){var g=[];c.each(e,function(h){if(h.data){g=g.concat(h.data)}else{c.each(h.points,function(i){g.push(i.value)})}});return g})();var f=(this.options.scaleOverride)?{steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+(this.options.scaleSteps*this.options.scaleStepWidth)}:c.calculateScaleRange(d,c.min([this.chart.width,this.chart.height])/2,this.options.scaleFontSize,this.options.scaleBeginAtZero,this.options.scaleIntegersOnly);c.extend(this.scale,f)},addData:function(e,d){this.scale.valuesCount++;c.each(e,function(f,h){var g=this.scale.getPointPosition(this.scale.valuesCount,this.scale.calculateCenterOffset(f));this.datasets[h].points.push(new this.PointClass({value:f,label:d,datasetLabel:this.datasets[h].label,x:g.x,y:g.y,strokeColor:this.datasets[h].pointStrokeColor,fillColor:this.datasets[h].pointColor}))},this);this.scale.labels.push(d);this.reflow();this.update()},removeData:function(){this.scale.valuesCount--;this.scale.labels.shift();c.each(this.datasets,function(d){d.points.shift()},this);this.reflow();this.update()},update:function(){this.eachPoints(function(d){d.save()});this.reflow();this.render()},reflow:function(){c.extend(this.scale,{width:this.chart.width,height:this.chart.height,size:c.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2});this.updateScaleRange(this.datasets);this.scale.setScaleSize();this.scale.buildYLabels()},draw:function(f){var e=f||1,d=this.chart.ctx;this.clear();this.scale.draw();c.each(this.datasets,function(g){c.each(g.points,function(h,i){if(h.hasValue()){h.transition(this.scale.getPointPosition(i,this.scale.calculateCenterOffset(h.value)),e)}},this);d.lineWidth=this.options.datasetStrokeWidth;d.strokeStyle=g.strokeColor;d.beginPath();c.each(g.points,function(h,i){if(i===0){d.moveTo(h.x,h.y)}else{d.lineTo(h.x,h.y)}},this);d.closePath();d.stroke();d.fillStyle=g.fillColor;if(this.options.datasetFill){d.fill()}c.each(g.points,function(h){if(h.hasValue()){h.draw()}})},this)}})}).call(this);