/*!
 * Bootstrap Colorpicker
 * http://mjolnic.github.io/bootstrap-colorpicker/
 *
 * Originally written by (c) 2012 Stefan Petre
 * Licensed under the Apache License v2.0
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * @todo Update DOCS
 */
(function(b){if(typeof exports==="object"){module.exports=b(window.jQuery)}else{if(typeof define==="function"&&define.amd){define(["jquery"],b)}else{if(window.jQuery&&!window.jQuery.fn.colorpicker){b(window.jQuery)}}}}(function(e){var g=function(a,b){this.value={h:0,s:0,b:0,a:1};this.origFormat=null;if(b){e.extend(this.colors,b)}if(a){if(a.toLowerCase!==undefined){a=a+"";this.setColor(a)}else{if(a.h!==undefined){this.value=a}}}};g.prototype={constructor:g,colors:{aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32",transparent:"transparent"},_sanitizeNumber:function(a){if(typeof a==="number"){return a}if(isNaN(a)||(a===null)||(a==="")||(a===undefined)){return 1}if(a.toLowerCase!==undefined){return parseFloat(a)}return 1},isTransparent:function(a){if(!a){return false}a=a.toLowerCase().trim();return(a==="transparent")||(a.match(/#?00000000/))||(a.match(/(rgba|hsla)\(0,0,0,0?\.?0\)/))},rgbaIsTransparent:function(a){return((a.r===0)&&(a.g===0)&&(a.b===0)&&(a.a===0))},setColor:function(a){a=a.toLowerCase().trim();if(a){if(this.isTransparent(a)){this.value={h:0,s:0,b:0,a:0}}else{this.value=this.stringToHSB(a)||{h:0,s:0,b:0,a:1}}}},stringToHSB:function(b){b=b.toLowerCase();var c;if(typeof this.colors[b]!=="undefined"){b=this.colors[b];c="alias"}var a=this,d=false;e.each(this.stringParsers,function(o,r){var p=r.re.exec(b),q=p&&r.parse.apply(a,[p]),i=c||r.format||"rgba";if(q){if(i.match(/hsla?/)){d=a.RGBtoHSB.apply(a,a.HSLtoRGB.apply(a,q))}else{d=a.RGBtoHSB.apply(a,q)}a.origFormat=i;return false}return true});return d},setHue:function(a){this.value.h=1-a},setSaturation:function(a){this.value.s=a},setBrightness:function(a){this.value.b=1-a},setAlpha:function(a){this.value.a=parseInt((1-a)*100,10)/100},toRGB:function(o,a,d,c){if(!o){o=this.value.h;a=this.value.s;d=this.value.b}o*=360;var p,b,r,q,s;o=(o%360)/60;s=d*a;q=s*(1-Math.abs(o%2-1));p=b=r=d-s;o=~~o;p+=[s,q,0,0,q,s][o];b+=[q,s,s,q,0,0][o];r+=[0,0,q,s,s,q][o];return{r:Math.round(p*255),g:Math.round(b*255),b:Math.round(r*255),a:c||this.value.a}},toHex:function(a,b,k,d){var c=this.toRGB(a,b,k,d);if(this.rgbaIsTransparent(c)){return"transparent"}return"#"+((1<<24)|(parseInt(c.r)<<16)|(parseInt(c.g)<<8)|parseInt(c.b)).toString(16).substr(1)},toHSL:function(a,b,n,m){a=a||this.value.h;b=b||this.value.s;n=n||this.value.b;m=m||this.value.a;var c=a,o=(2-b)*n,d=b*n;if(o>0&&o<=1){d/=o}else{d/=2-o}o/=2;if(d>1){d=1}return{h:isNaN(c)?0:c,s:isNaN(d)?0:d,l:isNaN(o)?0:o,a:isNaN(m)?0:m}},toAlias:function(a,b,m,l){var d=this.toHex(a,b,m,l);for(var c in this.colors){if(this.colors[c]===d){return c}}return false},RGBtoHSB:function(b,c,q,o){b/=255;c/=255;q/=255;var d,n,p,a;p=Math.max(b,c,q);a=p-Math.min(b,c,q);d=(a===0?null:p===b?(c-q)/a:p===c?(q-b)/a+2:(b-c)/a+4);d=((d+360)%6)*60/360;n=a===0?0:a/p;return{h:this._sanitizeNumber(d),s:n,b:p,a:this._sanitizeNumber(o)}},HueToRGB:function(a,b,c){if(c<0){c+=1}else{if(c>1){c-=1}}if((c*6)<1){return a+(b-a)*c*6}else{if((c*2)<1){return b}else{if((c*3)<2){return a+(b-a)*((2/3)-c)*6}else{return a}}}},HSLtoRGB:function(b,s,d,x){if(s<0){s=0}var q;if(d<=0.5){q=d*(1+s)}else{q=d+s-(d*s)}var p=2*d-q;var z=b+(1/3);var l=b;var c=b-(1/3);var r=Math.round(this.HueToRGB(p,q,z)*255);var a=Math.round(this.HueToRGB(p,q,l)*255);var y=Math.round(this.HueToRGB(p,q,c)*255);return[r,a,y,this._sanitizeNumber(x)]},toString:function(b){b=b||"rgba";var a=false;switch(b){case"rgb":a=this.toRGB();if(this.rgbaIsTransparent(a)){return"transparent"}return"rgb("+a.r+","+a.g+","+a.b+")";break;case"rgba":a=this.toRGB();return"rgba("+a.r+","+a.g+","+a.b+","+a.a+")";break;case"hsl":a=this.toHSL();return"hsl("+Math.round(a.h*360)+","+Math.round(a.s*100)+"%,"+Math.round(a.l*100)+"%)";break;case"hsla":a=this.toHSL();return"hsla("+Math.round(a.h*360)+","+Math.round(a.s*100)+"%,"+Math.round(a.l*100)+"%,"+a.a+")";break;case"hex":return this.toHex();break;case"alias":return this.toAlias()||this.toHex();default:return a;break}},stringParsers:[{re:/rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*?\)/,format:"rgb",parse:function(a){return[a[1],a[2],a[3],1]}},{re:/rgb\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*?\)/,format:"rgb",parse:function(a){return[2.55*a[1],2.55*a[2],2.55*a[3],1]}},{re:/rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,format:"rgba",parse:function(a){return[a[1],a[2],a[3],a[4]]}},{re:/rgba\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,format:"rgba",parse:function(a){return[2.55*a[1],2.55*a[2],2.55*a[3],a[4]]}},{re:/hsl\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*?\)/,format:"hsl",parse:function(a){return[a[1]/360,a[2]/100,a[3]/100,a[4]]}},{re:/hsla\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,format:"hsla",parse:function(a){return[a[1]/360,a[2]/100,a[3]/100,a[4]]}},{re:/#?([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/,format:"hex",parse:function(a){return[parseInt(a[1],16),parseInt(a[2],16),parseInt(a[3],16),1]}},{re:/#?([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/,format:"hex",parse:function(a){return[parseInt(a[1]+a[1],16),parseInt(a[2]+a[2],16),parseInt(a[3]+a[3],16),1]}}],colorNameToHex:function(a){if(typeof this.colors[a.toLowerCase()]!=="undefined"){return this.colors[a.toLowerCase()]}return false}};var h={horizontal:false,inline:false,color:false,format:false,input:"input",container:false,component:".add-on, .input-group-addon",sliders:{saturation:{maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setBrightness"},hue:{maxLeft:0,maxTop:100,callLeft:false,callTop:"setHue"},alpha:{maxLeft:0,maxTop:100,callLeft:false,callTop:"setAlpha"}},slidersHorz:{saturation:{maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setBrightness"},hue:{maxLeft:100,maxTop:0,callLeft:"setHue",callTop:false},alpha:{maxLeft:100,maxTop:0,callLeft:"setAlpha",callTop:false}},template:'<div class="colorpicker dropdown-menu"><div class="colorpicker-saturation"><i><b></b></i></div><div class="colorpicker-hue"><i></i></div><div class="colorpicker-alpha"><i></i></div><div class="colorpicker-color"><div /></div><div class="colorpicker-selectors"></div></div>',align:"right",customClass:null,colorSelectors:null};var f=function(a,b){this.element=e(a).addClass("colorpicker-element");this.options=e.extend(true,{},h,this.element.data(),b);this.component=this.options.component;this.component=(this.component!==false)?this.element.find(this.component):false;if(this.component&&(this.component.length===0)){this.component=false}this.container=(this.options.container===true)?this.element:this.options.container;this.container=(this.container!==false)?e(this.container):false;this.input=this.element.is("input")?this.element:(this.options.input?this.element.find(this.options.input):false);if(this.input&&(this.input.length===0)){this.input=false}this.color=new g(this.options.color!==false?this.options.color:this.getValue(),this.options.colorSelectors);this.format=this.options.format!==false?this.options.format:this.color.origFormat;this.picker=e(this.options.template);if(this.options.customClass){this.picker.addClass(this.options.customClass)}if(this.options.inline){this.picker.addClass("colorpicker-inline colorpicker-visible")}else{this.picker.addClass("colorpicker-hidden")}if(this.options.horizontal){this.picker.addClass("colorpicker-horizontal")}if(this.format==="rgba"||this.format==="hsla"||this.options.format===false){this.picker.addClass("colorpicker-with-alpha")}if(this.options.align==="right"){this.picker.addClass("colorpicker-right")}if(this.options.colorSelectors){var c=this;e.each(this.options.colorSelectors,function(k,l){var d=e("<i />").css("background-color",l).data("class",k);d.click(function(){c.setValue(e(this).css("background-color"))});c.picker.find(".colorpicker-selectors").append(d)});this.picker.find(".colorpicker-selectors").show()}this.picker.on("mousedown.colorpicker touchstart.colorpicker",e.proxy(this.mousedown,this));this.picker.appendTo(this.container?this.container:e("body"));if(this.input!==false){this.input.on({"keyup.colorpicker":e.proxy(this.keyup,this)});this.input.on({"change.colorpicker":e.proxy(this.change,this)});if(this.component===false){this.element.on({"focus.colorpicker":e.proxy(this.show,this)})}if(this.options.inline===false){this.element.on({"focusout.colorpicker":e.proxy(this.hide,this)})}}if(this.component!==false){this.component.on({"click.colorpicker":e.proxy(this.show,this)})}if((this.input===false)&&(this.component===false)){this.element.on({"click.colorpicker":e.proxy(this.show,this)})}if((this.input!==false)&&(this.component!==false)&&(this.input.attr("type")==="color")){this.input.on({"click.colorpicker":e.proxy(this.show,this),"focus.colorpicker":e.proxy(this.show,this)})}this.update();e(e.proxy(function(){this.element.trigger("create")},this))};f.Color=g;f.prototype={constructor:f,destroy:function(){this.picker.remove();this.element.removeData("colorpicker").off(".colorpicker");if(this.input!==false){this.input.off(".colorpicker")}if(this.component!==false){this.component.off(".colorpicker")}this.element.removeClass("colorpicker-element");this.element.trigger({type:"destroy"})},reposition:function(){if(this.options.inline!==false||this.options.container){return false}var b=this.container&&this.container[0]!==document.body?"position":"offset";var c=this.component||this.element;var a=c[b]();if(this.options.align==="right"){a.left-=this.picker.outerWidth()-c.outerWidth()}this.picker.css({top:a.top+c.outerHeight(),left:a.left})},show:function(a){if(this.isDisabled()){return false}this.picker.addClass("colorpicker-visible").removeClass("colorpicker-hidden");this.reposition();e(window).on("resize.colorpicker",e.proxy(this.reposition,this));if(a&&(!this.hasInput()||this.input.attr("type")==="color")){if(a.stopPropagation&&a.preventDefault){a.stopPropagation();a.preventDefault()}}if(this.options.inline===false){e(window.document).on({"mousedown.colorpicker":e.proxy(this.hide,this)})}this.element.trigger({type:"showPicker",color:this.color})},hide:function(){this.picker.addClass("colorpicker-hidden").removeClass("colorpicker-visible");e(window).off("resize.colorpicker",this.reposition);e(document).off({"mousedown.colorpicker":this.hide});this.update();this.element.trigger({type:"hidePicker",color:this.color})},updateData:function(a){a=a||this.color.toString(this.format);this.element.data("color",a);return a},updateInput:function(a){a=a||this.color.toString(this.format);if(this.input!==false){if(this.options.colorSelectors){var c=new g(a,this.options.colorSelectors);var b=c.toAlias();if(typeof this.options.colorSelectors[b]!=="undefined"){a=b}}this.input.prop("value",a)}return a},updatePicker:function(a){if(a!==undefined){this.color=new g(a,this.options.colorSelectors)}var c=(this.options.horizontal===false)?this.options.sliders:this.options.slidersHorz;var b=this.picker.find("i");if(b.length===0){return}if(this.options.horizontal===false){c=this.options.sliders;b.eq(1).css("top",c.hue.maxTop*(1-this.color.value.h)).end().eq(2).css("top",c.alpha.maxTop*(1-this.color.value.a))}else{c=this.options.slidersHorz;b.eq(1).css("left",c.hue.maxLeft*(1-this.color.value.h)).end().eq(2).css("left",c.alpha.maxLeft*(1-this.color.value.a))}b.eq(0).css({top:c.saturation.maxTop-this.color.value.b*c.saturation.maxTop,left:this.color.value.s*c.saturation.maxLeft});this.picker.find(".colorpicker-saturation").css("backgroundColor",this.color.toHex(this.color.value.h,1,1,1));this.picker.find(".colorpicker-alpha").css("backgroundColor",this.color.toHex());this.picker.find(".colorpicker-color, .colorpicker-color div").css("backgroundColor",this.color.toString(this.format));return a},updateComponent:function(a){a=a||this.color.toString(this.format);if(this.component!==false){var b=this.component.find("i").eq(0);if(b.length>0){b.css({backgroundColor:a})}else{this.component.css({backgroundColor:a})}}return a},update:function(b){var a;if((this.getValue(false)!==false)||(b===true)){a=this.updateComponent();this.updateInput(a);this.updateData(a);this.updatePicker()}return a},setValue:function(a){this.color=new g(a,this.options.colorSelectors);this.update(true);this.element.trigger({type:"changeColor",color:this.color,value:a})},getValue:function(b){b=(b===undefined)?"#000000":b;var a;if(this.hasInput()){a=this.input.val()}else{a=this.element.data("color")}if((a===undefined)||(a==="")||(a===null)){a=b}return a},hasInput:function(){return(this.input!==false)},isDisabled:function(){if(this.hasInput()){return(this.input.prop("disabled")===true)}return false},disable:function(){if(this.hasInput()){this.input.prop("disabled",true);this.element.trigger({type:"disable",color:this.color,value:this.getValue()});return true}return false},enable:function(){if(this.hasInput()){this.input.prop("disabled",false);this.element.trigger({type:"enable",color:this.color,value:this.getValue()});return true}return false},currentSlider:null,mousePointer:{left:0,top:0},mousedown:function(b){if(!b.pageX&&!b.pageY&&b.originalEvent){b.pageX=b.originalEvent.touches[0].pageX;b.pageY=b.originalEvent.touches[0].pageY}b.stopPropagation();b.preventDefault();var c=e(b.target);var d=c.closest("div");var k=this.options.horizontal?this.options.slidersHorz:this.options.sliders;if(!d.is(".colorpicker")){if(d.is(".colorpicker-saturation")){this.currentSlider=e.extend({},k.saturation)}else{if(d.is(".colorpicker-hue")){this.currentSlider=e.extend({},k.hue)}else{if(d.is(".colorpicker-alpha")){this.currentSlider=e.extend({},k.alpha)}else{return false}}}var a=d.offset();this.currentSlider.guide=d.find("i")[0].style;this.currentSlider.left=b.pageX-a.left;this.currentSlider.top=b.pageY-a.top;this.mousePointer={left:b.pageX,top:b.pageY};e(document).on({"mousemove.colorpicker":e.proxy(this.mousemove,this),"touchmove.colorpicker":e.proxy(this.mousemove,this),"mouseup.colorpicker":e.proxy(this.mouseup,this),"touchend.colorpicker":e.proxy(this.mouseup,this)}).trigger("mousemove")}return false},mousemove:function(a){if(!a.pageX&&!a.pageY&&a.originalEvent){a.pageX=a.originalEvent.touches[0].pageX;a.pageY=a.originalEvent.touches[0].pageY}a.stopPropagation();a.preventDefault();var b=Math.max(0,Math.min(this.currentSlider.maxLeft,this.currentSlider.left+((a.pageX||this.mousePointer.left)-this.mousePointer.left)));var c=Math.max(0,Math.min(this.currentSlider.maxTop,this.currentSlider.top+((a.pageY||this.mousePointer.top)-this.mousePointer.top)));this.currentSlider.guide.left=b+"px";this.currentSlider.guide.top=c+"px";if(this.currentSlider.callLeft){this.color[this.currentSlider.callLeft].call(this.color,b/this.currentSlider.maxLeft)}if(this.currentSlider.callTop){this.color[this.currentSlider.callTop].call(this.color,c/this.currentSlider.maxTop)}if(this.currentSlider.callTop==="setAlpha"&&this.options.format===false){if(this.color.value.a!==1){this.format="rgba";this.color.origFormat="rgba"}else{this.format="hex";this.color.origFormat="hex"}}this.update(true);this.element.trigger({type:"changeColor",color:this.color});return false},mouseup:function(a){a.stopPropagation();a.preventDefault();e(document).off({"mousemove.colorpicker":this.mousemove,"touchmove.colorpicker":this.mousemove,"mouseup.colorpicker":this.mouseup,"touchend.colorpicker":this.mouseup});return false},change:function(a){this.keyup(a)},keyup:function(a){if((a.keyCode===38)){if(this.color.value.a<1){this.color.value.a=Math.round((this.color.value.a+0.01)*100)/100}this.update(true)}else{if((a.keyCode===40)){if(this.color.value.a>0){this.color.value.a=Math.round((this.color.value.a-0.01)*100)/100}this.update(true)}else{this.color=new g(this.input.val(),this.options.colorSelectors);if(this.color.origFormat&&this.options.format===false){this.format=this.color.origFormat}if(this.getValue(false)!==false){this.updateData();this.updateComponent();this.updatePicker()}}}this.element.trigger({type:"changeColor",color:this.color,value:this.input.val()})}};e.colorpicker=f;e.fn.colorpicker=function(c){var d=arguments,a;var b=this.each(function(){var l=e(this),m=l.data("colorpicker"),n=((typeof c==="object")?c:{});if((!m)&&(typeof c!=="string")){l.data("colorpicker",new f(this,n))}else{if(typeof c==="string"){a=m[c].apply(m,Array.prototype.slice.call(d,1))}}});if(c==="getValue"){return a}return b};e.fn.colorpicker.constructor=f}));