let bootstrap = require('bootstrap');

require('../css/activityLog.css');

import Vue from 'vue';

import Router from 'vue-router'

import {store} from 'store'

import CKEditor from '@ckeditor/ckeditor5-vue';

import vSelect from 'vue-select'
Vue.component('v-select', vSelect)

Vue.use( CKEditor );

bootstrap.injectComponentIntoView('ticket-associated-list', require('./components/Ticket/TicketAssociatedList.vue'),'user-box-mounted','user-view-table');

bootstrap.injectComponentIntoView('associated-problem', require('./components/Problem/AssociatedProblem.vue'),'timeline-meta-box-mounted','timeline-meta-list-box');

bootstrap.injectComponentIntoView('sd-ticket-actions', require('./components/Ticket/SdTicketActions.vue'),'timeline-action-bar-mounted','timeline-action-bar');

//For asociated Assets, Contracts, Changes Tab
bootstrap.injectComponentIntoView('ticket-associated-list', require('./components/Ticket/TicketAssociatedList.vue'),'ticket-tab-mounted','timeline-tab');

bootstrap.injectComponentIntoView('ticket-associated-list', require('./components/Ticket/TicketAssociatedList.vue'),'org-page-mounted','org-page-table');
//

// injecting sd-agent-permission component into permission-list-box at agent CU page on permission-list-box-mounted event
bootstrap.injectComponentIntoView('sd-agent-permission', require("./components/Admin/Staff/Agent/SdAgentPermission.vue"), "permission-list-box-mounted", "permission-list-box");


bootstrap.injectComponentIntoView('create-form-group-button', require('./components/Common/CreateFormGroupButton.vue'),'create-form-group-button-mounted', 'form-group-create-button');

bootstrap.injectComponentIntoView('custom-type-form-field', require('./components/Common/CustomTypeFormField.vue'),'custom-type-form-field-mounted', 'faveo-app-extra-form-field');

// bootstrap.injectComponentIntoView('ticket-actions', require('./components/Ticket/TicketActions.vue'),'timeline-action-bar-mounted','timeline-action-bar');

// NOTE: Adding change conversation page route to client panel routes

import router from 'router/clientRouter';

import ClientLayout from 'components/Client/ClientPanelLayout.vue';

import ChangeConversation from './components/Client/Changes/ChangeConversation.vue';

import ContractConversation from './components/Client/Contract/ContractConversation.vue';

router.addRoutes([
      {

            path: '/change-approval',
      
            component: ClientLayout,
            
            name: 'SD Change Conversation',
            
            redirect: '/change-approval/:id',
            
            children: [
                  {

                        path: '/change-approval/:id',

                        component: ChangeConversation,
                        
                        name: 'ChangeConversation',
                        
                        meta: { breadcrumb: [{text:'ChangeConversation'}]}
                  }
            ]
      },

      {

            path: '/service-desk/contract-approval',
      
            component: ClientLayout,
            
            name: 'SD Contract Conversation',
            
            redirect: '/service-desk/contract-approval/:hash/:id',
            
            children: [

                  {
                        path: '/service-desk/contract-approval/:hash/:id',

                        component: ContractConversation,
                        
                        name: 'ContractConversation',
                        
                        meta: { breadcrumb: [{text:'Contract Approval'}]}
                  }
            ]
      }
]);


// NOTE: Adding Reports page route to agent panel routes

import agentRoutes from 'router/agentRouter';

import AgentLayout from 'components/Agent/AgentPanelLayout.vue';

//REPORT HOME
import ReportEntry from './components/Report/ReportEntry';

//REPORT HOME
import ReportIndex from './components/Report/ReportsIndex.vue';

//REPORT CREATE AND EDIT
import ReportCreateEdit from './components/Report/ReportNestedFilter.vue';

//REPORT CREATE AND EDIT
import ReportView from './components/Report/ReportView.vue';

//ASSETS INDEX
import AssetIndex from './components/Asset/AssetIndex.vue';

//ASSETS CREATE EDIT
import AssetCreateEdit from './components/Asset/AssetForm.vue';

//ASSETS VIEW
import AssetView from './components/Asset/AssetView.vue';

//PROBLEM INDEX
import ProblemIndex from './components/Problem/ProblemIndex.vue';

//PROBLEM CREATE EDIT
import ProblemCreateEdit from './components/Problem/Problem.vue';

//PROBLEM VIEW
import ProblemView from './components/Problem/ProblemViewPage.vue';

//CHANGE INDEX
import ChangesIndex from './components/Agent/Changes/ChangesIndex.vue';

//CHANGE CREATE EDIT
import ChangeCreateEdit from './components/Agent/Changes/ChangesCreateEdit.vue';

//CHANGE VIEW
import ChangeView from './components/Agent/Changes/ChangesView.vue';

//CONTRACTS INDEX
import ContractsIndex from './components/Agent/Contract/ContractsIndex.vue';

//CONTRACT CREATE EDIT
import ContractCreateEdit from './components/Agent/Contract/ContractCreateEdit.vue';

//CHANGE VIEW
import ContractView from './components/Agent/Contract/ContractView.vue';

//RELEASES INDEX
import ReleasesIndex from './components/Agent/Release/ReleasesIndex.vue';

//RELEASE CREATE EDIT
import ReleaseCreateEdit from './components/Agent/Release/ReleaseCreateEdit.vue';

//RELEASE VIEW
import ReleaseView from './components/Agent/Release/ReleaseView.vue';

let problemsMenu = {

      path: '/service-desk/problem',
      
      component: AgentLayout,
      
      name: 'SD Problems',
      
      redirect: '/service-desk/problem/list',
      
      children: [
            
            {
            
                  path: 'list',
            
                  name: 'Problem Index',
            
                  component: ProblemIndex,

                  meta: { title : 'problem', crumb : { link: { name : 'dashboard', to : '/' }, active : 'problem' } }
            },

            {
            
                  path: 'create',
            
                  name: 'Problem Create',
            
                  component: ProblemCreateEdit,

                  meta: { title : 'problem', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'problem', to : '/service-desk/problem/list' }, active : 'create' } }
            },

            {
            
                  path: ':id/edit',
            
                  name: 'Problem Edit',
            
                  component: ProblemCreateEdit,

                  meta: { title : 'problem', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'problem', to : '/service-desk/problem/list' }, active : 'edit' } }
            },

            {
            
                  path: ':id/show',
            
                  name: 'Problem View',
            
                  component: ProblemView,

                  meta: { title : 'problem', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'problem', to : '/service-desk/problem/list' }, active : 'view' } }
            }
      ]
}

let changesMenu = {

      path: '/service-desk/changes',
      
      component: AgentLayout,
      
      name: 'SD Changes',
      
      redirect: '/service-desk/changes/list',
      
      children: [
            
            {
            
                  path: 'list',
            
                  name: 'Changes Index',
            
                  component: ChangesIndex,

                  meta: { title : 'changes', crumb : { link: { name : 'dashboard', to : '/' }, active : 'changes' } }
            },

            {
            
                  path: 'create',
            
                  name: 'Change Create',
            
                  component: ChangeCreateEdit,

                  meta: { title : 'changes', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'changes', to : '/service-desk/changes/list' }, active : 'create' } }
            },

            {
            
                  path: ':id/edit',
            
                  name: 'Change Edit',
            
                  component: ChangeCreateEdit,

                  meta: { title : 'changes', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'changes', to : '/service-desk/changes/list' }, active : 'edit' } }
            },

            {
            
                  path: ':id/show',
            
                  name: 'Change View',
            
                  component: ChangeView,

                  meta: { title : 'changes', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'changes', to : '/service-desk/changes/list' }, active : 'view' } }
            }
      ]
}

let assetsMenu = {
      
      path: '/service-desk/assets',

      component: AgentLayout,
      
      name: 'Servicedesk Assets',
      
      redirect : '/service-desk/assets/list',
      
      children : [
            {
                  path: 'list',

                  component: AssetIndex,
                  
                  name: 'SD Assets Index',

                  meta: { title : 'assets', crumb : { link: { name : 'dashboard', to : '/' }, active : 'assets' } }
            },

            {
            
                  path: 'create',
            
                  name: 'Asset Create',
            
                  component: AssetCreateEdit,

                  props: { category : 'asset', panel : 'agent' },

                  meta: { title : 'assets', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'assets', to : '/service-desk/assets/list' }, active : 'create' } }
            },

            {
            
                  path: ':id/edit',
            
                  name: 'Asset Edit',
            
                  component: AssetCreateEdit,

                  props: { category : 'asset', panel : 'agent' },

                  meta: { title : 'assets', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'assets', to : '/service-desk/assets/list' }, active : 'edit' } }
            },

            {
                  path: ':id/show',

                  component: AssetView,
                  
                  name: 'SD Assets View',

                  meta: { title : 'assets', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'assets', to : '/service-desk/assets/list' }, active : 'view' } }
            },
      ]
}

let contractsMenu = {
      
      path: '/service-desk/contracts',

      component: AgentLayout,
      
      name: 'Servicedesk Contracts',
      
      redirect : '/service-desk/contracts/list',
      
      children : [
            {
                  path: 'list',

                  component: ContractsIndex,
                  
                  name: 'SD Contracts Index',

                  meta: { title : 'contracts', crumb : { link: { name : 'dashboard', to : '/' }, active : 'contracts' } }
            },

            {
            
                  path: 'create',
            
                  name: 'Contract Create',
            
                  component: ContractCreateEdit,

                  meta: { title : 'contracts', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'contracts', to : '/service-desk/contracts/list' }, active : 'create' } }
            },

            {
            
                  path: ':id/edit',
            
                  name: 'Contract Edit',
            
                  component: ContractCreateEdit,

                  meta: { title : 'contracts', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'contracts', to : '/service-desk/contracts/list' }, active : 'edit' } }
            },

            {
                  path: ':id/show',

                  component: ContractView,
                  
                  name: 'SD Contract View',

                  meta: { title : 'contracts', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'contracts', to : '/service-desk/contracts/list' }, active : 'view' } }
            },
      ]
}

let releasesMenu = {
      
      path: '/service-desk/releases',

      component: AgentLayout,
      
      name: 'Servicedesk Releases',
      
      redirect : '/service-desk/releases/list',
      
      children : [
            {
                  path: 'list',

                  component: ReleasesIndex,
                  
                  name: 'SD Release Index',

                  meta: { title : 'releases', crumb : { link: { name : 'dashboard', to : '/' }, active : 'releases' } }
            },

            {
            
                  path: 'create',
            
                  name: 'Release Create',
            
                  component: ReleaseCreateEdit,

                  meta: { title : 'releases', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'releases', to : '/service-desk/releases/list' }, active : 'create' } }
            },

            {
            
                  path: ':id/edit',
            
                  name: 'Release Edit',
            
                  component: ReleaseCreateEdit,

                  meta: { title : 'releases', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'releases', to : '/service-desk/releases/list' }, active : 'edit' } }
            },

            {
                  path: ':id/show',

                  component: ReleaseView,
                  
                  name: 'SD Release View',

                  meta: { title : 'releases', crumb : { link: { name : 'dashboard', to : '/' }, root_link: { name : 'releases', to : '/service-desk/releases/list' }, active : 'view' } }
            },
      ]
}

agentRoutes.addRoutes([
      {
            path: '/service-desk/reports',

            component: AgentLayout,
            
            name: 'Servicedesk Reports',
            
            redirect : '/service-desk/reports/get',
            
            children : [
                  {
                       
                        path: 'get',
                       
                        component: ReportEntry,
                       
                        name: 'SD Reports Home',
                        
                        meta: { title : 'servicedesk_reports', crumb : { active : 'servicedesk_reports' } }
                  },

                  {
                        
                        path: 'assets',
                       
                        component: ReportIndex,
                       
                        name: 'SD Reports Index',
                        
                        meta: { title : 'assets_report', crumb : { link: { name : 'servicedesk_reports', to : '/service-desk/reports/get' }, active : 'assets_report' } }
                  },

                  {
                       
                        path: 'assets/create',

                        component: ReportCreateEdit,
                       
                        name: 'SD Reports Create',
                        
                        meta: { title : 'assets_report', crumb : {  link: { name : 'servicedesk_reports', to : '/service-desk/reports/get' }, root_link: { name : 'assets_report', to : '/service-desk/reports/assets' }, active : 'create' } }
                  },

                  {

                        path: 'assets/edit/:id',
                       
                        component: ReportCreateEdit,
                       
                        name: 'SD Reports Edit',
                        
                         meta: { title : 'assets_report', crumb : {  link: { name : 'servicedesk_reports', to : '/service-desk/reports/get' }, root_link: { name : 'assets_report', to : '/service-desk/reports/assets' }, active : 'edit' } }
                  },

                  {
                        
                        path: 'assets/:id',
                       
                        component: ReportView,
                       
                        name: 'SD Reports View',
                        
                         meta: { title : 'assets_report', crumb : {  link: { name : 'servicedesk_reports', to : '/service-desk/reports/get' }, root_link: { name : 'assets_report', to : '/service-desk/reports/assets' }, active : 'view' } }
                  }
            ]
      },

      problemsMenu,

      changesMenu,

      assetsMenu,

      contractsMenu,

      releasesMenu
]);

// ==========================================================================================

store.dispatch('deleteUser');
store.dispatch('updateUser');

new Vue({
    
    el: '#app-sevicedesk',
    
    store: store,
    
    components: {
                  
      'agent-asset-index' : require('./components/Report/AgentAssetIndex.vue'),

      'cab-index' : require('./components/Admin/Cab/CabIndex.vue'),

      'cab-create-edit' : require('./components/Admin/Cab/CabCreateEdit.vue'),

      'contract-type-index' : require('./components/Admin/ContractType/ContractTypeIndex.vue'),

      'contract-type-create-edit' : require('./components/Admin/ContractType/ContractTypeCreateEdit.vue'),

      'assetstypes-index' : require('./components/Admin/AssetsTypes/AssetTypeIndex.vue'),

      'assetstypes-create-edit' : require('./components/Admin/AssetsTypes/AssetTypeCreateEdit.vue'),
      
      'vendor-index' : require('./components/Admin/Vendor/VendorIndex.vue'),

      'vendor-create-edit' : require('./components/Admin/Vendor/VendorCreateEdit.vue'),

      'vendor-view' : require('./components/Admin/Vendor/VendorView.vue'),

      'procurement-type-index' : require('./components/Admin/ProcurementType/ProcurementTypeIndex.vue'),

      'procurement-type-create-edit' : require('./components/Admin/ProcurementType/ProcurementTypeCreateEdit.vue'),

      'license-type-index' : require('./components/Admin/LicenseType/LicenseTypeIndex.vue'),

      'license-type-create-edit' : require('./components/Admin/LicenseType/LicenseTypeCreateEdit.vue'),

      'announcement' : require('./components/Admin/Announcement/Announcement.vue'),

      //PRODUCTS
      'products-index' : require('./components/Admin/Products/ProductsIndex.vue'),      
      
      'product-create-edit' : require('./components/Admin/Products/ProductCreateEdit.vue'),   

      'product-view' : require('./components/Admin/Products/ProductView.vue'),

      'barcode-settings' : require('./components/Admin/Barcode/BarcodeSettings.vue'),

      'barcode-settings' : require('./components/Admin/Barcode/BarcodeSettings.vue'),


      //ASSET STATUS
      
      'asset-status-index' : require('./components/Admin/AssetStatus/AssetStatusIndex.vue'),

      'asset-status-create-edit' : require('./components/Admin/AssetStatus/AssetStatusCreateEdit.vue'),

      'barcode-settings' : require('./components/Admin/Barcode/BarcodeSettings.vue'),

      'sd-importer': require('./components/Common/SdImporter'),

      'sd-import-mapper': require('./components/Common/SdImportMapper'),

      'sd-import-progress' : require('./components/Common/SdimportProgress')
    }
});
