import { shallowMount } from '@vue/test-utils'

import ProblemBulkActionModal from '../../../../../views/js/components/Problem/View/MiniComponents/ProblemBulkActionModal.vue';

import Vue from 'vue'

import moxios from 'moxios'

jest.mock('helpers/responseHandler')

window.eventHub = new Vue();

const fakeRequestData = {
    'success':true,
    'data':{}
}

describe('ProblemBulkActionModal',()=>{

    let wrapper;

    beforeEach(() => {
        moxios.install();

        wrapper = shallowMount(ProblemBulkActionModal,{
            propsData : { onClose : jest.fn(), identifier: 'change_status', tickets: [1], componentTitle: "problem-associated-ticket-alert" },
            
            mocks:{
                stubs:['modal','loader','dynamic-select','radio-button'],
                lang:(string)=>string
            }
        })
    });

    afterEach(() => {
        moxios.uninstall();
    });

	it('reaches api when `onSubmit` is invoked', async (done) => {
		
        moxios.stubRequest('service-desk/api/problem-bulk-actions',{
            status:200,
            response:fakeRequestData
        })

        await wrapper.vm.onSubmit();

        Vue.nextTick(()=> {
            expect(moxios.requests.mostRecent().config.url).toBe('service-desk/api/problem-bulk-actions');

            expect(wrapper.vm.onClose).toHaveBeenCalled();

            done();
        })
	})
});
