import { shallow, createLocalVue,  mount } from '@vue/test-utils'

import sinon from 'sinon'

import Vue from 'vue'

import Vuex from 'vuex'

import VueRouter from 'vue-router'

import ReleaseActions from '../../../../../../views/js/components/Agent/Release/View/Mini/ReleaseActions.vue';

const router = new VueRouter();

import * as extraLogics from "helpers/extraLogics";

let localVue = createLocalVue()

window.eventHub = new Vue();

localVue.use(Vuex)

describe('ReleaseActions',() => {

	let wrapper;

	let actions
  
  let store

  actions = { unsetValidationError: jest.fn() }

 	store = new Vuex.Store({ actions })

	const updateWrapper = () =>{

		wrapper = mount(ReleaseActions,{

			stubs: ['release-planning-modal','release-assets','release-change','release-status-modal','delete-modal','loader','router-link'],
			
			mocks:{ trans:(string)=>string },

			methods : { basePath : jest.fn() },

			propsData : { releaseId : 1, actions : { release_asset_attach : 1, release_change_attach : 1, release_edit : 1, release_delete : 1, release_completed : 1}  },

			localVue, store, router
		})  
	}
	
	beforeEach(() => {
		
		updateWrapper();
		
	})

	it('returns only 15 characters if value length is more than 15 and returns exact value if option length not more than 15',() => {		
		
		expect(wrapper.vm.subString('name name name name name ')).toEqual('name name name ...');

		expect(wrapper.vm.subString('name')).toEqual('name');
	});

	it('updates `showPlanningModal, identifier` values when `planningMethod` method called',()=>{

		wrapper.vm.planningMethod('reason');

		expect(wrapper.vm.showPlanningModal).toEqual(true)

		expect(wrapper.vm.identifier).toEqual('reason')
	})

	it("`showModal` should be `false` when `onClose` method called",()=>{

		updateWrapper();

		wrapper.vm.onClose();
		
		expect(wrapper.vm.showPlanningModal).toBe(false);

		expect(actions.unsetValidationError).toHaveBeenCalled();
	})
})