import SdImporter from "../../../../views/js/components/Common/SdImporter";
import SdImportMapper from '../../../../views/js/components/Common/SdImportMapper'
import { mount } from '@vue/test-utils';
import moxios from 'moxios'

const fakeResponse = {
    status: 200,
    response :{}
}

describe('SdImporter', () => {
    let wrapper;

    beforeEach(() => {
        moxios.install()

        wrapper = mount(SdImporter, {
            stubs:['sd-import-mapper','file','alert','faveo-box','custom-loader', 'discard-sd-import-modal'],

            mocks: {
                lang: (string) => string
            },
            propsData: {
                uploadUrl: 'upload-csv',
                discardUrl: '#',
                mappingPostUrl: 'post-mapping-details/',
                mappingDetailsGetUrl : 'asset-get-mapping-details',
            }
        })

    })

    afterEach(() => {
        moxios.uninstall()
    })

    it('checks presence of stubs while creation', function () {
        expect(wrapper.find('alert-stub').exists()).toBe(true)
        expect(wrapper.find('faveo-box-stub').exists()).toBe(true)
    });

    it('should not show `SdImportMapper` component by default', () => {
        expect(wrapper.find('sd-import-mapper-stub').exists()).toBe(false)
    })

    it('should show `SdImportMapper` component after uploading file successfully', (done) => {
        wrapper.setData({uploaded: true});

        setTimeout(() => {
            expect(wrapper.find('sd-import-mapper-stub').exists()).toBe(true)
            done()
        },1)
    })

    it('should hide faveo-box after uploading file successfully', function (done) {
        wrapper.setData({uploaded: true});

        setTimeout(() => {
            expect(wrapper.find('faveo-box-stub').exists()).toBe(false)
            done()
        },1)
    });

    it('should hit `uploadUrl` when user uploads file', (done) => {
        const uploadUrl = wrapper.vm.uploadUrl;

        moxios.stubRequest(uploadUrl, {
            status: 200,
            response: { data: {} }
        })

        wrapper.vm.submitCallback = jest.fn();

        wrapper.find('#upload-btn').trigger('click');

        setTimeout(() => {
            expect(moxios.requests.mostRecent().url).toBe(uploadUrl);
            done();
        }, 1)

    });

    it('should react `discard` event from `SdImportMapper`', () => {
        wrapper.setData({uploaded: true});
        wrapper.vm.discardImportProcessing = jest.fn();

        // at the time of writing this @vue/test-utils: ^1.0.0-beta.25 in which findComponent() is not available
        // from version 1.1.2, usage of find() for finding components is deprecated
        // findComponent() is recommended; adding here to keep in mind while future upgrades of the package
        wrapper.find(SdImportMapper).vm.$emit('sdImportDiscardModalButtonClicked');
        setTimeout(() => {
            expect(wrapper.vm.discardImportProcessing).toHaveBeenCalledTimes(1);
            expect(wrapper.vm.showModal).toBe(false);
        }, 1)
    });
});
