import SdImportMapper from "../../../../views/js/components/Common/SdImportMapper";
import { shallowMount } from '@vue/test-utils';
import mockAxios from "axios";


jest.mock('axios');
mockAxios.get.mockResolvedValue({
    data: {
        data: {
            columns_to_import: [
                { id: 1, name: 'import_attribute_1', required: true },
                { id: 2, name: 'import_attribute_2', required: false }
            ],
            csv_headers_for_mapping: [
                { id: 1, name: 'csv_attribute_1' },
                { id: 2, name: 'csv_attribute_2' }
            ]
        }
    }
});

mockAxios.post.mockResolvedValue({
    status: 200,
    data: { message: 'OK' }
});

describe('SdImportMapper', () => {
    let wrapper;

    beforeEach(() => {
        wrapper = shallowMount(SdImportMapper, {
            mocks: {
                lang: (string) => string
            },
            stubs:['alert','form-field-template','loader','tool-tip'],
            propsData: {
                updateParent: jest.fn(),
                getDetailsApiEndpoint: 'service-desk/get-asset-mapping-details/',
                submitApiEndpoint: 'service-desk/asset-post-mapping',
                tableHeadings: {
                    system : { header: 'cool' },
                    thirdParty: { header: 'warm' },
                },
                discardUrl: '#'

            },

        })
    });

    afterEach(() => {
        jest.clearAllMocks()
    });

    it('should make an api call to server before mount and shows `system attributes`', async () => {
        expect(wrapper.vm.systemAttributes.length).toBe(2);
        expect(wrapper.vm.importAttributes.length).toBe(2);
        expect(wrapper.vm.loading).toBe(false);
        expect(wrapper.vm.hasDataPopulated).toBe(true);
        expect(mockAxios.get).toHaveBeenCalledTimes(1);
    });

    it('should hit the post route and call `updateParent` after success', async () => {
        await wrapper.vm.onSubmit();
        setTimeout(() => {
            expect(wrapper.vm.updateParent).toHaveBeenCalled();
            expect(mockAxios.post).toHaveBeenCalledTimes(1);
        }, 1)
    });

    it('should emit `discard` event when user discards the import', () => {
        wrapper.vm.emitDiscardModalButtonIsClicked = jest.fn();
        wrapper.vm.emitDiscardModalButtonIsClicked();
        expect(wrapper.find('#discard-import-button').exists()).toBe(false);
        setTimeout(() => {
            expect(wrapper.emitted().sdImportDiscardModalButtonClicked).toBeTruthy();
        }, 1);
    });
});
